#include <stdio.h>

#define DP 5

int g1[9], g2[9], g3[9], g4[9], g5[9];

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	    s = 0;
	    for(j = 0; j < m; j++) s += a[i * m + j] * b[j * n + k];
	    c[i * n + k] = s;
	}
    }
}

void draw(int s[])
{
    double x1, x2, x3, x4, x5, y1, y2, y3, y4, y5;

    x1 = (double) s[0] / (double) s[10];
    y1 = (double) s[5] / (double) s[10];
    x2 = (double) s[1] / (double) s[11];
    y2 = (double) s[6] / (double) s[11];
    x3 = (double) s[2] / (double) s[12];
    y3 = (double) s[7] / (double) s[12];
    x4 = (double) s[3] / (double) s[13];
    y4 = (double) s[8] / (double) s[13];
    x5 = (double) s[4] / (double) s[14];
    y5 = (double) s[9] / (double) s[14];
    printf("color 0 0 3\nconnect %f %f %f %f\n", x1, y1, x2, y2);
    printf("connect %f %f %f %f\n", x1, y1, x5, y5);
    printf("color 0 3 0\nconnect %f %f %f %f\n", x2, y2, x3, y3);
    printf("connect %f %f %f %f\n", x4, y4, x5, y5);
    printf("gray 0\nconnect %f %f %f %f\n", x3, y3, x4, y4);
    printf("color 3 0 0\nconnect %f %f %f %f\n", x1, y1, .5 * (x3 + x4), .5 * (y3 + y4));
    return;
}

void ex(int s[], int depth, int e)
{
    int t[15];

    if(depth == 3) return;
    depth++;
    if(e != 1) {
          mtxmul(g1, s, t, 3, 3, 5);
	  draw(t);
	  ex(t, depth, 1);
    }
    if(e != 4) {
          mtxmul(g2, s, t, 3, 3, 5);
	  draw(t);
	  ex(t, depth, 2);
    }
    if(e != 3) {
          mtxmul(g3, s, t, 3, 3, 5);
	  draw(t);
	  ex(t, depth, 3);
    }
    if(e != 2) {
          mtxmul(g4, s, t, 3, 3, 5);
	  draw(t);
	  ex(t, depth, 4);
    }
    if(e != 5) {
          mtxmul(g5, s, t, 3, 3, 5);
	  draw(t);
	  ex(t, depth, 5);
    }
}

main()
{
    int s[15], t[15];

    s[0] = s[1] = s[5]= s[9] = s[10] = s[11] = s[12] = s[13] = s[14] = 1;
    s[2] = s[4] = s[6] = s[8] = 0;
    s[3] = s[7] = -1;
    g1[0] = -5; g1[1] = 0; g1[2] = 6;
    g1[3] = -2; g1[4] = -1; g1[5] = 3;
    g1[6] = -4; g1[7] = 0; g1[8] = 5;
    g2[0] = g2[2] = 1; g2[1] = 0;
    g2[3] = g2[7] = -2; g2[4] = g2[8] = 3;
    g2[5] = -3; g2[6] = 2;
    g3[0] = g3[2] = g3[4] = g3[5] = -1;
    g3[1] = g3[3] = g3[6] = g3[7] = 0;
    g3[8] = 1;
    g4[0] = g4[8] = 3; g4[1] = g4[6] = -2;
    g4[2] = -3; g4[3] = 0; g4[4] = g4[5] = 1;
    g4[7] = 2;
    g5[0] = -1; g5[1] = -2; g5[2] = 3;
    g5[3] = g5[6] = 0; g5[4] = -5; g5[5] = 6;
    g5[7] = -4; g5[8] = 5;
    //    draw(s);
    mtxmul(g1, s, t, 3, 3, 5);
    draw(t);
    ex(t, 0, 1);
    mtxmul(g2, s, t, 3, 3, 5);
    draw(t);
    ex(t, 0, 1);
    mtxmul(g3, s, t, 3, 3, 5);
    draw(t);
    ex(t, 0, 1);
    mtxmul(g4, s, t, 3, 3, 5);
    draw(t);
    ex(t, 0, 1);
    mtxmul(g5, s, t, 3, 3, 5);
    draw(t);
    ex(t, 0, 1);
    return 0;
}
