#include <stdio.h>

#define DP 5

int g1[9], g2[9], g3[9], s[18];

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	    s = 0;
	    for(j = 0; j < m; j++) s += a[i * m + j] * b[j * n + k];
	    c[i * n + k] = s;
	}
    }
}

void draw(int s[])
{
    double x1, x2, x3, y1, y2, y3, x4, y4, x5, y5, x6, y6;

    x1 = (double) s[0] / (double) s[12];
    y1 = (double) s[6] / (double) s[12];
    x2 = (double) s[1] / (double) s[13];
    y2 = (double) s[7] / (double) s[13];
    x3 = (double) s[2] / (double) s[14];
    y3 = (double) s[8] / (double) s[14];
    x4 = (double) s[3] / (double) s[15];
    y4 = (double) s[9] / (double) s[15];
    x5 = (double) s[4] / (double) s[16];
    y5 = (double) s[10] / (double) s[16];
    x6 = (double) s[5] / (double) s[17];
    y6 = (double) s[11] / (double) s[17];
    printf("gray 0\nconnect %f %f %f %f %f %f\n", x1, y1, x2, y2, x3, y3);
    printf("color 0 0 3\nconnect %f %f %f %f %f %f\n", x3, y3, x4, y4, x5, y5);
    printf("color 3 0 0\nconnect %f %f %f %f %f %f\n", x1, y1, x6, y6, x5, y5);
    return;
}

void ex(int s[], int dp)
{
    int t[18];

    if(dp > 5) return;
    dp++;
    mtxmul(g1, s, t, 3, 3, 6);
    draw(t);
    ex(t, dp);
    mtxmul(g2, s, t, 3, 3, 6);
    draw(t);
    ex(t, dp);
    mtxmul(g3, s, t, 3, 3, 6);
    draw(t);
    ex(t, dp);
}

main(int argc, char *argv[])
{
    int i, t[18], u[18], a, b, c;

    if(argc > 1) a = atoi(argv[1]);
    else a = 3;
    if(argc > 2) b = atoi(argv[2]);
    else b = 2;
    if(argc > 3) c = atoi(argv[3]);
    else c = 1;
    for(i = 0; i < 18; i++) s[i] = 1;
    s[2] = s[5] = s[6] = s[9] = 0;
    s[3] = s[4] = s[10] = s[11] = -1;
    g1[0] = -3; g1[1] = 1; g1[2] = 3; g1[4] = g1[7] = 0;
    //    g1[5] = 6; g1[6] = -4; g1[8] = 5; g1[3] = -5; 
    //g1[5] = 4; g1[6] = -2; g1[8] = 3; g1[3] = -3;
    g1[5] = a + 3; g1[6] = -a - 1; g1[8] = a + 2; g1[3] = -a -2; 
    g2[0] = g2[3] = -1; g2[1] = g2[2] = b; g2[4] = -2; g2[5] = -3;
    g2[6] = 0; g2[7] = b + 1; g2[8] = b + 2;
    g3[0] = -c - 2; g3[1] = g3[8] = c + 2; g3[2] = -c - 3; g3[3] = g3[5] = -c;
    g3[4] = c - 1; g3[6] = c + 1; g3[7] = -c - 1;
    /*
    g3[0] = -4; g3[1] = g3[8] = 4; g3[2] = -5; g3[3] = g3[5] = -2;
    g3[4] = 1; g3[6] = 3; g3[7] = -3;
    draw(s);
    mtxmul(g1, s, t, 3, 3, 6);
    draw(t);
    mtxmul(g2, s, t, 3, 3, 6);
    draw(t);
    mtxmul(g2, t, u, 3, 3, 6);
    draw(u);
    mtxmul(g3, s, t, 3, 3, 6);
    draw(t);
    */
    ex(s, 0);
    return 0;
}
