#include <stdio.h>

#define DP 5

int g1[9], g2[9], g3[9], g4[9], g11[9], g21[9], g31[9], g41[9], s[24];

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	    s = 0;
	    for(j = 0; j < m; j++) s += a[i * m + j] * b[j * n + k];
	    c[i * n + k] = s;
	}
    }
}

void draw(int s[])
{
    double x1, x2, x3, y1, y2, y3, x4, y4, x5, y5, x6, y6, x7, y7, x8, y8;

    x1 = (double) s[0] / (double) s[16];
    y1 = (double) s[8] / (double) s[16];
    x2 = (double) s[1] / (double) s[17];
    y2 = (double) s[9] / (double) s[17];
    x3 = (double) s[2] / (double) s[18];
    y3 = (double) s[10] / (double) s[18];
    x4 = (double) s[3] / (double) s[19];
    y4 = (double) s[11] / (double) s[19];
    x5 = (double) s[4] / (double) s[20];
    y5 = (double) s[12] / (double) s[20];
    x6 = (double) s[5] / (double) s[21];
    y6 = (double) s[13] / (double) s[21];
    x7 = (double) s[6] / (double) s[22];
    y7 = (double) s[14] / (double) s[22];
    x8 = (double) s[7] / (double) s[23];
    y8 = (double) s[15] / (double) s[23];
    printf("gray 0\nconnect %f %f %f %f\nconnect %f %f %f %f\n", x1, y1, x2, y2, x5, y5, x6, y6);
    printf("color 0 0 3\nconnect %f %f %f %f\nconnect %f %f %f %f\n", x2, y2, x3, y3, x6, y6, x7, y7);
    printf("color 3 0 0\nconnect %f %f %f %f\nconnect %f %f %f %f\n", x3, y3, x4, y4, x7, y7, x8, y8);
    printf("color 0 3 0\nconnect %f %f %f %f\nconnect %f %f %f %f\n", x5, y5, x4, y4, x1, y1, x8, y8);
    return;
}

void ex(int s[], int dir, int d)
{
    int t[24];

    draw(s);
    if(d > 4) return;
    d++;
    if(dir != 5) {
        mtxmul(g1, s, t, 3, 3, 8);
	ex(t, 1, d);
    }
    if(dir != 6) {
        mtxmul(g2, s, t, 3, 3, 8);
	ex(t, 2, d);
    }
    if(dir != 7) {
        mtxmul(g3, s, t, 3, 3, 8);
	ex(t, 3, d);
    }
    if(dir != 8) {
        mtxmul(g4, s, t, 3, 3, 8);
	ex(t, 4, d);
    }
    if(dir != 1) {
        mtxmul(g11, s, t, 3, 3, 8);
	ex(t, 5, d);
    }
    if(dir != 2) {
        mtxmul(g21, s, t, 3, 3, 8);
	ex(t, 6, d);
    }
    if(dir != 3) {
        mtxmul(g31, s, t, 3, 3, 8);
	ex(t, 7, d);
    }
    if(dir != 4) {
        mtxmul(g41, s, t, 3, 3, 8);
	ex(t, 8, d);
    }
}

main(int argc, char *argv[])
{
    int i, t[24], u[24];

    for(i = 16; i < 24; i++) s[i] = 1;
    s[0] = s[11] = s[5] = s[14] = 0;
    s[2] = s[3] = s[8] = s[9] = 2;
    s[6] = s[7] = s[12] = s[13] = -1;
    s[1] = s[4] = s[10] = s[15] = 1;
    draw(s);
    g1[0] = -1; g1[1] = 2; g1[2] = 3;
    g1[3] = g1[6] = 0; g1[4] = 9; g1[5] = 11; g1[7] = 4; g1[8] = 5;
    g21[0] = g21[4] = 2; g21[1] = g21[3] = 1; g21[2] = g21[5] = -5; g21[6] = g21[7] = -2; g21[8] = 7;
    g2[0] = g2[4] = 4; g2[1] = g2[3] = g2[8] = 3; g2[2] = g2[5] = 5; g2[6] = g2[7] = 2;
    g3[0] = 9; g3[1] = g3[7] = 0; g3[2] = 11; g3[3] = 2; g3[4] = -1; g3[5] = 3; g3[6] = 4; g3[8] = 5;
    g4[0] = g4[7] = 2; g4[1] = -1; g4[2] = -4; g4[3] = -3; g4[4] = 4; g4[5] = 8; g4[6] = -2; g4[8] =  5;
    g11[0] = -1; g11[1] = -2; g11[2] = g11[4] = 5; g11[3] = g11[6] = 0; g11[5] = -11; g11[7] = -4; g11[8] = 9;
    g31[0] = g31[5] = 5; g31[1] = g31[7] = 0; g31[2] = -11; g31[3] = -2; g31[4] = -1; g31[6] = -4; g31[8] = 9;
    g41[0] = 4; g41[1] = -3; g41[2] = 8; g41[3] = -1; g41[4] = g41[6] = 2; g41[5] = -4; g41[7] = -2; g41[8] = 5;
    /*
    mtxmul(g1, s, t, 3, 3, 8);
    draw(t);
    mtxmul(g21, t, u, 3, 3, 8);
    draw(u);
    mtxmul(g2, s, t, 3, 3, 8);
    draw(t);
    mtxmul(g3, s, t, 3, 3, 8);
    draw(t);
    mtxmul(g4, s, t, 3, 3, 8);
    draw(t);
    mtxmul(g11, s, t, 3, 3, 8);
    draw(t);
    mtxmul(g21, s, t, 3, 3, 8);
    draw(t);
    mtxmul(g31, s, t, 3, 3, 8);
    draw(t);
    mtxmul(g41, s, t, 3, 3, 8);
    draw(t);
    */
    mtxmul(g1, s, t, 3, 3, 8);
    ex(t, 1, 0);
    return 0;
}
