#include <stdio.h>

#define DP 5

int a[9], b[9], ai[9], bi[9], c[9];

void mtxmul(int a[], int b[], int c[], int l, int m, int n)
{
    int i, j, k, s;

    for(i = 0; i < l; i++) {
        for(k = 0; k < n; k++) {
	    s = 0;
	    for(j = 0; j < m; j++) s += a[i * m + j] * b[j * n + k];
	    c[i * n + k] = s;
	}
    }
}

void display(int a[], int m, int n)
{
    int i, j;

    for(i = 0; i < m; i++) {
        for(j = 0; j < n; j++) {
	  printf("%d ", a[i * n + j]);
	}
	printf("\n");
    }
}

void up(int m[], int depth)
{
    int d[9];
    double x, y, x2, y2, x3, y3;

    mtxmul(c, m, d, 3, 3, 3);
    x = (double) d[0] / (double) d[6];
    y = (double) d[3] / (double) d[6];
    x2 = (double) d[1] / (double) d[7];
    y2 = (double) d[4] / (double) d[7];
    x3 = (double) d[2] / (double) d[8];
    y3 = (double) d[5] / (double) d[8];
    printf("connect %f %f %f %f %f %f\n", x3, y3, x, y, x2, y2);
    if( depth == DP) return;
    mtxmul(a, m, d, 3, 3, 3);
    up(d, depth + 1);
    return;
}

void down(int m[], int depth)
{
    int d[9];
    double x, y, x2, y2, x3, y3;

    mtxmul(c, m, d, 3, 3, 3);
    x = (double) d[0] / (double) d[6];
    y = (double) d[3] / (double) d[6];
    x2 = (double) d[1] / (double) d[7];
    y2 = (double) d[4] / (double) d[7];
    x3 = (double) d[2] / (double) d[8];
    y3 = (double) d[5] / (double) d[8];
    printf("connect %f %f %f %f %f %f\n", x3, y3, x, y, x2, y2);
    if( depth == DP) return;
    mtxmul(ai, m, d, 3, 3, 3);
    down(d, depth + 1);
    return;
}

void right(int m[], int depth)
{
    int d[9];
    double x, y, x2, y2, x3, y3;

    mtxmul(c, m, d, 3, 3, 3);
    x = (double) d[0] / (double) d[6];
    y = (double) d[3] / (double) d[6];
    x2 = (double) d[1] / (double) d[7];
    y2 = (double) d[4] / (double) d[7];
    x3 = (double) d[2] / (double) d[8];
    y3 = (double) d[5] / (double) d[8];
    printf("connect %f %f %f %f %f %f\n", x3, y3, x, y, x2, y2);
    if( depth == DP) return;
    mtxmul(b, m, d, 3, 3, 3);
    right(d, depth + 1);
    mtxmul(a, m, d, 3, 3, 3);
    up(d, 0);
    mtxmul(ai, m, d, 3, 3, 3);
    down(d, 0);
    return;
}

void left(int m[], int depth)
{
    int d[9];
    double x, y, x2, y2, x3, y3;

    mtxmul(c, m, d, 3, 3, 3);
    x = (double) d[0] / (double) d[6];
    y = (double) d[3] / (double) d[6];
    x2 = (double) d[1] / (double) d[7];
    y2 = (double) d[4] / (double) d[7];
    x3 = (double) d[2] / (double) d[8];
    y3 = (double) d[5] / (double) d[8];
    printf("connect %f %f %f %f %f %f\n", x3, y3, x, y, x2, y2);
    if( depth == DP) return;
    mtxmul(bi, m, d, 3, 3, 3);
    left(d, depth + 1);
    mtxmul(a, m, d, 3, 3, 3);
    up(d, 0);
    mtxmul(ai, m, d, 3, 3, 3);
    down(d, 0);
    return;
}

main()
{
    int d[9], e[9];
    double x, y, x2, y2, x3, y3;

    a[0] = a[3] = 0; a[1] = -2; a[2] = -1; a[4] = 3; a[5] = a[6] = a[7] = 1;a[8] = 2;
    ai[0] = 5; ai[1] = 3; ai[2] = ai[3] = ai[4] = 1; ai[5] = ai[8] = 0; ai[6] = -3; ai[7] = -2;
    b[0] = b[6] = 0; b[1] = -3; b[2] = -2; b[3] = b[7] = b[8] = 1; b[4] = 5; b[5] = 3; 
    bi[0] = 2; bi[1] = bi[2] = bi[6] = 1; bi[3] = -1; bi[4] = bi[7] = 0; bi[5] = -2; bi[8] = 3;
    c[0] = c[2] = c[3] = c[4] = 0; c[1] = c[5] = c[6] = c[7] = c[8] = 1;
    printf("connect 0 1 0 0 1 0\n");
    right(b, 0);
    left(bi, 0);
    up(a, 0);
    down(ai, 0);
    /*    mtxmul(c, a, d, 3, 3, 3);
    x = (double) d[0] / (double) d[6];
    y = (double) d[3] / (double) d[6];
    x2 = (double) d[1] / (double) d[7];
    y2 = (double) d[4] / (double) d[7];
    x3 = (double) d[2] / (double) d[8];
    y3 = (double) d[5] / (double) d[8];
    printf("connect %f %f %f %f %f %f\n", x3, y3, x, y, x2, y2);
    */
    return 0;
}
