#include <stdio.h>
#include <stdlib.h>

typedef struct mt {
	int a, b, c, d;
} MT;

MT mtx[100];

int mul(int i, int j)
{
	if(i == 0) return 0;
	if(j == 0) return 0;
	if(i == 1) return j;
	if(j == 1) return i;
	if(i != j) return 1;
	if(i == 2) return 3;
	return 2;
}

int sum(int i, int j)
{
	if(i == 0) return j;
	if(j == 0) return i;
	if(i == j) return 0;
	if(i == 1) {
		if(j == 2) return 3;
		return 2;
	}
	if(i == 2) {
		if(j == 1) return 3;
		return 1;
	}
	if(j == 1) return 2;
	return 1;
}

MT mtmul(MT X, MT Y)
{
	MT Z;

	Z.a = sum(mul(X.a, Y.a), mul(X.b, Y.c));
	Z.b = sum(mul(X.a, Y.b), mul(X.b, Y.d));
	Z.c = sum(mul(X.c, Y.a), mul(X.d, Y.c));
	Z.d = sum(mul(X.c, Y.b), mul(X.d, Y.d));
	return Z;
}

int alex(MT A, int l)
{
	int i;

	for(i = 0; i < l; i++) {
		if(A.a != mtx[i].a) continue;
		if(A.b != mtx[i].b) continue;
		if(A.c != mtx[i].c) continue;
		if(A.d != mtx[i].d) continue;
		return i;
	}
	return -1;
}

int main()
{
	int a, b, c, d, i, j, l = 1;
	MT Z;

	mtx[0].a = mtx[0].d = 1; mtx[0].b = mtx[0].c = 0;
	for(a = 0; a < 4; a++) {
		for(b = 0; b < 4; b++) {
			for(c = 0; c <4; c++) {
				for(d = 0; d < 4; d++) {
					if(sum(mul(a, d), mul(b, c)) == 1) {
						mtx[l].a = a; mtx[l].b = b; mtx[l].c = c; mtx[l].d = d;
						if(alex(mtx[l], 1) == 0) continue;
						l++;
						fprintf(stderr, "%d:\n%d %d\n%d %d\n", l, a, b, c, d);
					}
				}
			}
		}
	}
	for(i = 0; i < l; i++) {
		for(j = 0; j < l; j++) {
			Z = mtmul(mtx[i], mtx[j]);
			printf("%d ", alex(Z, l));
		}
		printf("\n");
	}
	return 0;
}
