#include <stdio.h>
#include <stdlib.h>

typedef struct mt {
	int a, b, c, d;
} MT;

MT mtx[600];

int sum[64] = {0, 1, 2, 3, 4, 5, 6, 7,
			   1, 0, 3, 2, 5, 4, 7, 6,
			   2, 3, 0, 1, 6, 7, 4, 5,
			   3, 2, 1, 0, 7, 6, 5, 4,
			   4, 5, 6, 7, 0, 1, 2, 3,
			   5, 4, 7, 6, 1, 0, 3, 2,
			   6, 7, 4, 5, 2, 3, 0, 1,
			   7, 6, 5, 4, 3, 2, 1, 0},
	mul[64] = {0, 0, 0, 0, 0, 0, 0, 0,
			   0, 1, 2, 3, 4, 5, 6, 7,
			   0, 2, 4, 6, 3, 1, 7, 5,
			   0, 3, 6, 5, 7, 4, 1, 2,
			   0, 4, 3, 7, 6, 2, 5, 1,
			   0, 5, 1, 4, 2, 7, 3, 6,
			   0, 6, 7, 1, 5, 3, 2, 4,
			   0, 7, 5, 2, 1, 6, 4, 3};

MT mtmul(MT X, MT Y)
{
	MT Z;

	Z.a = sum[mul[X.a * 8 + Y.a] * 8 + mul[X.b * 8 + Y.c]];
	Z.b = sum[mul[X.a * 8 + Y.b] * 8 + mul[X.b * 8 + Y.d]];
	Z.c = sum[mul[X.c * 8 + Y.a] * 8 + mul[X.d * 8 + Y.c]];
	Z.d = sum[mul[X.c * 8 + Y.b] * 8 + mul[X.d * 8 + Y.d]];
	return Z;
}

int alex(MT A, int l)
{
	int i;

	for(i = 0; i < l; i++) {
		if(A.a != mtx[i].a) continue;
		if(A.b != mtx[i].b) continue;
		if(A.c != mtx[i].c) continue;
		if(A.d != mtx[i].d) continue;
		return i;
	}
	return -1;
}

int main()
{
	int a, b, c, d, i, j, l = 1;
	MT Z;

	mtx[0].a = mtx[0].d = 1; mtx[0].b = mtx[0].c = 0;
	for(a = 0; a < 8; a++) {
		for(b = 0; b < 8; b++) {
			for(c = 0; c < 8; c++) {
				for(d = 0; d < 8; d++) {
					if(sum[mul[a * 8 + d] * 8 + mul[b * 8 + c]] == 1) {
						mtx[l].a = a; mtx[l].b = b; mtx[l].c = c; mtx[l].d = d;
						if(alex(mtx[l], 1) == 0) continue;
						l++;
						//fprintf(stderr, "%d:\n%d %d\n%d %d\n", l, a, b, c, d);
					}
				}
			}
		}
	}
	for(i = 0; i < l; i++) {
		for(j = 0; j < l; j++) {
			Z = mtmul(mtx[i], mtx[j]);
			printf("%d ", alex(Z, l));
		}
		printf("\n");
	}
	return 0;
}
