#include <stdio.h>
#include <stdlib.h>

typedef struct mt {
	int a, b, c, d;
} MT;

MT mtx[1200];

int sum[81] = {0, 1, 2, 3, 4, 5, 6, 7, 8,
			   1, 2, 0, 4, 5, 3, 7, 8, 6,
			   2, 0, 1, 5, 3, 4, 8, 6, 7,
			   3, 4, 5, 6, 7, 8, 0, 1, 2,
			   4, 5, 3, 7, 8, 6, 1, 2, 0,
			   5, 3, 4, 8, 6, 7, 2, 0, 1,
			   6, 7, 8, 0, 1, 2, 3, 4, 5,
			   7, 8, 6, 1, 2, 0, 4, 5, 3,
			   8, 6, 7, 2, 0, 1, 5, 3, 4},
	mul[81] = {0, 0, 0, 0, 0, 0, 0, 0, 0,
			   0, 1, 2, 3, 4, 5, 6, 7, 8,
			   0, 2, 1, 6, 8, 7, 3, 5, 4,
			   0, 3, 6, 2, 5, 8, 1, 4, 7,
			   0, 4, 8, 5, 6, 1, 7, 2, 3,
			   0, 5, 7, 8, 1, 3, 4, 6, 2,
			   0, 6, 3, 1, 7, 4, 2, 8, 5,
			   0, 7, 5, 4, 2, 6, 8, 3, 1,
			   0, 8, 4, 7, 3, 2, 5, 1, 6},
	inv[9];

MT mtmul(MT X, MT Y)
{
	MT Z;

	Z.a = sum[mul[X.a * 9 + Y.a] * 9 + mul[X.b * 9 + Y.c]];
	Z.b = sum[mul[X.a * 9 + Y.b] * 9 + mul[X.b * 9 + Y.d]];
	Z.c = sum[mul[X.c * 9 + Y.a] * 9 + mul[X.d * 9 + Y.c]];
	Z.d = sum[mul[X.c * 9 + Y.b] * 9 + mul[X.d * 9 + Y.d]];
	return Z;
}

int alex(MT A, int l)
{
	int i;

	for(i = 0; i < l; i++) {
		if(A.a != mtx[i].a) continue;
		if(A.b != mtx[i].b) continue;
		if(A.c != mtx[i].c) continue;
		if(A.d != mtx[i].d) continue;
		return i;
	}
	return -1;
}

int main()
{
	int a, b, c, d, i, j, l = 1;
	MT Z;

	for(i = 0; i < 9; i++) {
		for(j = 0; j < 9; j++) if(sum[i * 9 + j] == 0) break;
		inv[i] = j;
	}
	mtx[0].a = mtx[0].d = 1; mtx[0].b = mtx[0].c = 0;
	for(a = 0; a < 9; a++) {
		for(b = 0; b < 9; b++) {
			for(c = 0; c < 9; c++) {
				for(d = 0; d < 9; d++) {
					if(sum[mul[a * 9 + d] * 9 + inv[mul[b * 9 + c]]] == 1) {
						mtx[l].a = a; mtx[l].b = b; mtx[l].c = c; mtx[l].d = d;
						if(alex(mtx[l], 1) == 0) continue;
						l++;
						//fprintf(stderr, "%d:\n%d %d\n%d %d\n", l, a, b, c, d);
					}
				}
			}
		}
	}
	for(i = 0; i < l; i++) {
		for(j = 0; j < l; j++) {
			Z = mtmul(mtx[i], mtx[j]);
			printf("%d ", alex(Z, l));
		}
		printf("\n");
	}
	return 0;
}
