/*
al2r n : 位数 n の環 R の和と堰の演算表を読み込んで SL(2, R) の演算表を出力
 */
#include <stdio.h>
#include <stdlib.h>

#define MAXL 2500
#define MAXO 100

typedef struct mt {
	int a, b, c, d;
} MT;

MT mtx[MAXL];
int sum[MAXO * MAXO], mul[MAXO * MAXO], inv[MAXO], n;

MT mtmul(MT X, MT Y)
{
	MT Z;

	Z.a = sum[mul[X.a * n + Y.a] * n + mul[X.b * n + Y.c]];
	Z.b = sum[mul[X.a * n + Y.b] * n + mul[X.b * n + Y.d]];
	Z.c = sum[mul[X.c * n + Y.a] * n + mul[X.d * n + Y.c]];
	Z.d = sum[mul[X.c * n + Y.b] * n + mul[X.d * n + Y.d]];
	return Z;
}

int alex(MT A, int l)
{
	int i;

	for(i = 0; i < l; i++) {
		if(A.a != mtx[i].a) continue;
		if(A.b != mtx[i].b) continue;
		if(A.c != mtx[i].c) continue;
		if(A.d != mtx[i].d) continue;
		return i;
	}
	return -1;
}

int main(int argc, char *argv[])
{
	int a, b, c, d, i, j, l = 1;
	MT Z;

	if(argc < 2) {
		fprintf(stderr, "One parameter needed\n");
		return 0;
	}
	n = atoi(argv[1]);
	if(n > MAXO || n < 3) return 0;
	for(i = 0; i < n * n; i++) scanf("%d", sum + i);
	for(i = 0; i < n; i++) mul[i] = mul[i * n] = 0;
	for(i = 1; i < n; i++) {
		for(j = 1; j < n; j++) scanf("%d", mul + i * n + j);
	}
	for(i = 0; i < n; i++) {
		for(j = 0; j < n; j++) if(sum[i * n + j] == 0) break;
		inv[i] = j;
	}
	mtx[0].a = mtx[0].d = 1; mtx[0].b = mtx[0].c = 0;
	for(a = 0; a < n; a++) {
		for(b = 0; b < n; b++) {
			for(c = 0; c < n; c++) {
				for(d = 0; d < n; d++) {
					if(sum[mul[a * n + d] * n + inv[mul[b * n + c]]] == 1) {
						mtx[l].a = a; mtx[l].b = b; mtx[l].c = c; mtx[l].d = d;
						if(alex(mtx[l], 1) == 0) continue;
						l++;
						//fprintf(stderr, "%d:\n%d %d\n%d %d\n", l, a, b, c, d);
					}
				}
			}
		}
	}
	for(i = 0; i < l; i++) {
		for(j = 0; j < l; j++) {
			Z = mtmul(mtx[i], mtx[j]);
			printf("%d ", alex(Z, l));
		}
		printf("\n");
	}
	return 0;
}
