#include <stdio.h>
#include <stdlib.h>

int x[20000], n = 0;

void itom(int a, int m[])
{
	int i;

	for(i = 0; i < 9; i++) {
		m[i] = a % 3;
		a /= 3;
	}
}

void disp(int m[])
{
	int i;

	for(i = 0; i < 9; i++) {
		fprintf(stderr, "%d ", m[i]);
		if(((i + 1) % 3) == 0) fprintf(stderr, "\n");
	}
}

int isort(int m[])
{
	int i, j, k, s;

	for(i = 0; i < 3; i++) {
		for(j = 0; j < 3; j++) {
			for(s = k = 0; k < 3; k++) s += m[k * 3 + i] * m[k * 3 + j];
			s %= 3;
			if((i == j) && (s != 1)) return -1;
			if((i != j) && (s != 0)) return -1;
		}
	}
	return 1;
}

int mtoi(int m[])
{
	int i, h = 0;

	for(i = 8; i >= 0; i--) {
		h *= 3;
		h += m[i];
	}
	return h;
}

int mul(int i, int j)
{
	int k, l, h, a[9], b[9], c[9];

	itom(i, a);
	itom(j, b);
	for(k = 0; k < 3; k++) {
		for(l = 0; l < 3; l++) {
			int s = 0;
			for(h = 0; h < 3; h++) s += a[k * 3 + h] * b[h * 3 + l];
			c[k * 3 + l] = s % 3;
		}
	}
	h = mtoi(c);
	for(k = 0; k < n; k++) if(x[k] == h) return k;
	//	disp(c);
	return -1;
}

int main()
{
	int i, j, m[9];

	x[n++] = 6643;
	for(i = 0; i < 19683; i++) {
		if(i == 6643) continue;
		itom(i, m);
		if(isort(m) > 0) {
			fprintf(stderr, "%d(%d)\n", n, mtoi(m));
			disp(m);
			x[n++] = i;
		}
	}
	for(i = 0; i < n; i++) {
		for(j = 0; j < n; j++) printf("%d ", mul(x[i], x[j]));
		printf("\n");
	}
	return 0;
}
