#include <stdio.h>
#include <stdlib.h>

typedef struct plane {
    double a, b, c, d;
} Plane;

typedef struct pointin3d {
    double x, y, z;
} POINT;

double operator *(POINT a, POINT b)
{
	return a.x * b.x + a.y * b.y + a.z * b.z;
}

POINT operator -(POINT a, POINT b)
{
	POINT c;

	c.x = a.x - b.x;
	c.y = a.y - b.y;
	c.z = a.z - b.z;
	return c;
}

POINT operator +(POINT a, POINT b)
{
	POINT c;

	c.x = a.x + b.x;
	c.y = a.y + b.y;
	c.z = a.z + b.z;
	return c;
}

POINT operator *(double r, POINT a)
{
	POINT b;

	b.x = r * a.x;
	b.y = r * a.y;
	b.z = r * a.z;
	return b;
}

Plane operator |(POINT a, POINT b)
{
	Plane h;

	h.a = a.x - b.x;
	h.b = a.y - b.y;
	h.c = a.z - b.z;
	h.d = (a.x * a.x + a.y * a.y + a.z * a.z - b.x * b.x - b.y * b.y - b.z * b.z) / 2.;
	return h;
}
