#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "spacegeometry.h"

POINT nv(POINT a, POINT b, POINT c)
{
	POINT h;

	h.x = a.y * b.z + b.y * c.z + c.y * a.z - a.y * c.z - b.y * a.z - c.y * b.z;
	h.y = a.z * b.x + b.z * c.x + c.z * a.x - a.z * c.x - b.z * a.x - c.z * b.x;
	h.z = a.x * b.y + b.x * c.y + c.x * a.y - a.x * c.y - b.x * a.y - c.x * b.y;
	return h;
}

POINT ortho(POINT a, POINT b, POINT c)
{
	double s, t, u, d, a11, a12, a13, a21, a22, a23, x11, x12, x13, x22, x23, x33;
	POINT v;
	x11 = a * a; x12 = a * b; x13 = a * c; x22 = b * b; x23 = b * c; x33 = c * c;
	a11 = x12 - x13; a12 = x22 - x23; a13 = x23 - x33;
	a21 = x13 - x11; a22 = x23 - x12; a23 = x33 - x13;
	d = a11 * a22 + a12 * a23 + a13 * a21 - a11 * a23 - a22 * a13 - a12 * a21;
	s = (a11 * a22 + a12 * a23 + a13 * a22 - a11 * a23 - a22 * a13 - a12 * a22) / d;
	t = (a11 * a22 + a11 * a23 + a13 * a21 - a11 * a23 - a22 * a13 - a11 * a21) / d;
	u = (a11 * a22 + a12 * a22 + a11 * a21 - a11 * a22 - a22 * a11 - a12 * a21) / d;
	v.x = s * a.x + t * b.x + u * c.x;
	v.y = s * a.y + t * b.y + u * c.y;
	v.z = s * a.z + t * b.z + u * c.z;
	return v;
}

POINT sptetra(POINT a, POINT b, POINT c)
{
	POINT a2, b2, c2, oc, d;
	double nr, rt;

	a2 = b + c - a;
	b2 = c + a - b;
	c2 = a + b - c;
	//	printf("%f = 2x%f\n", sqrt((a2 - b2) * (a2 - b2)), sqrt((a - b) * (a - b)));
	oc = ortho(a2, b2, c2);
	//	printf("%f, %f, %f\n", (b - c) * (b - c) - (oc - a) * (oc - a), (c - a) * (c - a) - (oc - b) * (oc - b), (a - b) * (a - b) - (oc - c) * (oc - c));
	if((nr = (b - c) * (b - c) - (a - oc) * (a - oc)) < 0.) exit(0);
	d = nv(a, b, c);
	rt = sqrt(nr / (d * d));
	d = rt * d + oc;
	return d;
}

int main(int argc, char *argv[])
{
	POINT a, b, c, d;

	if(argc < 10) return 0;
	a.x = atof(argv[1]);
	a.y = atof(argv[2]);
	a.z = atof(argv[3]);
	b.x = atof(argv[4]);
	b.y = atof(argv[5]);
	b.z = atof(argv[6]);
	c.x = atof(argv[7]);
	c.y = atof(argv[8]);
	c.z = atof(argv[9]);
	d = sptetra(a, b, c);
	printf("%f = %f, %f = %f, %f = %f\n", (a - d) * (a - d), (b - c) * (b - c), (b - d) * (b - d), (a - c) * (a - c), (c - d) * (c - d), (b - a) * (b - a));
	return 0;
}
