#include <stdio.h>
#include <stdlib.h>
#include <math.h>


typedef struct {
    double r, i;
} CPX;

double abs(CPX z)
{
    return sqrt(z.r * z.r + z.i * z.i);
}

CPX sqrtofcpx(CPX z)
{
	CPX w;
	double a, s;

	a = sqrt(abs(z));
	s = atan2(z.i, z.r) / 2;
	w.r = a * cos(s);
	w.i = a * sin(s);
	return w;
}
	
int main(int argc, char *argv[])
{
	CPX z, w;

	if(argc < 3) return -1;
	z.r = atof(argv[1]);
	z.i = atof(argv[2]);
	w = sqrtofcpx(z);
	printf("%f + i%f = (%f + i%f)^2\n", z.r, z.i, w.r, w.i);
	return 0;
}
