#include "planegeometry.h"
#include <math.h>

void drtangents(CIRC c, POINT P)
{
	POINT Q;
	double x10, y10, r2, A, B, C;

	x10 = c.c.x - P.x;
	y10 = c.c.y - P.y;
	r2 = c.r * c.r;
	A = x10 * x10 + y10 * y10;
	B = x10 * r2;
	C = r2 * (r2 - y10 * y10);
	Q.x = (-B + sqrt(B * B - A * C)) / A + c.c.x;
	Q.y = -(x10 * (Q.x - c.c.x) + r2) / y10 + c.c.y;
	WRITE(Q, P);
	Q.x = (-B - sqrt(B * B - A * C)) / A + c.c.x;
	Q.y = -(x10 * (Q.x - c.c.x) + r2) / y10 + c.c.y;
	WRITE(Q, P);
}

int main(int argc, char *argv[])
{
	CIRC c;
	POINT P;

	c.c.x = -1.5; c.c.y = 0.1; c.r = 1.2;
	P.x = 1.; P.y = -0.5;
	WRITE(c);
	/*
	printf("gray 0.5\n");
	WRITE(c.c, P);
	*/
	printf("color 0 0 3\n");
	drtangents(c, P);
	return 0;
}
