#include "planegeometry.h"
#include <math.h>

POINT pt[8], pt2[4];
LINE ln[8], ln2[8];

int main(int argc, char *argv[])
{
	int i, j;

	if(argc < 7) return 0;
	for(i = 0; i < 6; i++) {
		double s = atof(argv[i + 1]);
		ln[i].a = cos(s);
		ln[i].b = sin(s);
		ln[i].c = -1.;
	}
	ln[6] = ln[0]; ln[7] = ln[1];
	printf("gray .5\ncircle 0 0 1\ngray 0\n");
	for(i = 0; i < 6; i++) {
		WRITE(ln[i]);
		pt[i] = ln[i] * ln[i + 2];
	}
	pt[6] = pt[0]; pt[7] = pt[1];
	printf("color 0 0 3\n");
	for(i = 0; i < 3; i++) pt2[i] = ln[i] * ln[i + 3];
	pt2[3] = pt2[0];
	for(i = 0; i < 3; i++) WRITE(pt2[i] * pt2[i + 1]);
	printf("color 3 0 0\n");
	for(i = 0; i < 6; i++) WRITE(ln2[i] = pt[i] * pt[i + 1]);
	for(i = 0; i < 3; i++) {
		pt2[i] = ln2[i] * ln2[i + 3];
		printf("disk %f %f .1\n", pt2[i].x, pt2[i].y);
	}
	printf("color 3 2 0\n");
	WRITE(pt2[0] * pt2[1]);
	return 0;
}
