#include <math.h>
#include "planegeometry.h"

void READ(POINT *p)
{
    scanf("%lf%lf", &p->x, &p->y);
    return;
}

void READ(LINE *l)
{
    scanf("%lf%lf%lf", &l->a, &l->b, &l->c);
    return;
}

void READ(CIRC *c)
{
    scanf("%lf%lf%lf", &(c->c).x, &(c->c).y, &c->r);
    return;
}

void WRITE(CIRC c)
{
    printf("circle %f %f %f\n", c.c.x, c.c.y, c.r);
    return;
}

void WRITE2(CIRC c){
    if(c.r == 0.) {
         double s, x, y;

	 s = atan2(c.c.y, c.c.x);
	 x = cos(s); y = sin(s);
	 printf("connect %f %f %f %f\n", x, y, -x, -y);
    }
    else {
        double s, t;

	s = atan2(1., c.r);
	t = atan2(c.c.y, c.c.x);
	if(t < 0.) t += M_PI;
	else t -= M_PI;
	printf("circle %f %f %f %f %f\n", c.c.x, c.c.y, c.r, (t - s) * 64. * 180. / M_PI, s * 128. * 180. / M_PI);
	/*
	  fprintf(stderr, "c.x = %f, c.y = %f, r = %f, t = %f, s = %f\n", c.c.x, c.c.y, c.r, t, s);
	*/
    }
}

void WRITE(LINE l)
{
    printf("line %f %f %f\n", l.a, l.b, l.c);
    return;
}

void WRITE(POINT p, POINT q, POINT r)
{
    printf("connect %f %f %f %f %f %f %f %f\n", p.x, p.y, q.x, q.y, r.x, r.y, p.x, p.y);
    return;
}

void WRITE(POINT p, POINT q)
{
    printf("connect %f %f %f %f\n", p.x, p.y, q.x, q.y);
    return;
}

void WRITE(POINT p)
{
    printf("disk %f %f .05\n", p.x, p.y);
}

LINE operator *(CIRC c, CIRC d)
{
    LINE l;


    l.a = 2. * (d.c.x - c.c.x);
    l.b = 2. * (d.c.y - c.c.y);
    l.c = -.5 * l.a * (d.c.x + c.c.x) - .5 * l.b * (d.c.y + c.c.y) + (d.r - c.r) * (d.r + c.r);
    return l;
}

LINE operator |(POINT p, POINT q)
{
    POINT midpt;
    LINE l;

    midpt.x = (p.x + q.x) / 2.;
    midpt.y = (p.y + q.y) / 2.;
    l.a = p.x - q. x;
    l.b = p.y - q.y;
    l.c = -l.a * midpt.x - l.b * midpt.y;
    return l;
}

LINE operator |(POINT p, LINE l)
{
    LINE m;

    m.a = l.b; m.b = -l.a;
    m.c = -m.a * p.x - m.b * p.y;
    return m;
}

LINE operator /(POINT p, LINE l)
{
    LINE m;

    m.a = l.a; m.b = l.b;
    m.c = -m.a * p.x - m.b * p.y;
    return m;
}

POINT operator %(POINT p, POINT q)
{
    POINT midpt;

    midpt.x = (p.x + q.x) / 2.;
    midpt.y = (p.y + q.y) / 2.;
    return midpt;
}

POINT operator *(LINE l1, LINE l2)
{
    double d;
    POINT p;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) {
	fprintf(stderr, "Error\n");
	exit(0);
    }
    p.x = (l2.c * l1.b - l1.c * l2.b) / d;
    p.y = (l2.a * l1.c - l1.a * l2.c) / d;
    return p;
}

POINT operator %(POINT p, LINE l)
{
    POINT q;
    double a2, b2, a2pb2, a2mb2;

    a2 = l.a * l.a; b2 = l.b * l.b;
    a2pb2 = a2 + b2;
    a2mb2 = a2 - b2;
    q.x = -(a2mb2 * p.x + 2. * l.a * l.b * p.y + 2. * l.a * l.c) / a2pb2;
    q.y = -(-a2mb2 * p.y + 2. * l.a * l.b * p.x + 2. * l.b * l.c) / a2pb2;
    return q;
}

LINE operator *(POINT p, POINT q)
{
    LINE l;

    l.a = p.y - q.y;
    l.b = q.x - p.x;
    l.c = -l.a * p.x - l.b * p.y;
    return l;
}

CIRC operator -(CIRC c1, CIRC c2)
{
    LINE l1, l2;
    CIRC c;

    if(c1.r == 0.) {
        l1.a = c1.c.y; l1.b = -c1.c.x; l1.c = 0.;
    }
    else {
        l1.a = 2. * c1.c.x; l1.b = 2. * c1.c.y;
	l1.c = c1.r * c1.r - 1. - c1.c.x * c1.c.x - c1.c.y * c1.c.y;
    }
    if(c2.r == 0.) {
        l2.a = c2.c.y; l2.b = -c2.c.x; l2.c = 0.;
    }
    else {
        l2.a = 2. * c2.c.x; l2.b = 2. * c2.c.y;
	l2.c = c2.r * c2.r - 1. - c2.c.x * c2.c.x - c2.c.y * c2.c.y;
    }
    c.c = l1 * l2;
    c.r = sqrt(c.c.x * c.c.x + c.c.y * c.c.y -1.);
    return c;
}

POINT operator &(CIRC c1, CIRC c2)
{
    POINT P0, P, v;
    LINE l;
    double d1, d;

    l = c1 * c2;
    P = l * (c1.c * c2.c);
    d1 = P + c1.c;
    d = sqrt(c1.r * c1.r - d1 * d1);
    v.x = l.b; v.y = -l.a;
    d1 = sqrt(v.x * v.x + v.y * v.y);
    v.x *= d / d1; v.y *= d / d1;
    P.x += v.x; P.y += v.y;
    if(P.x * P.x + P.y * P.y >= 1.) {
        P.x -= 2. * v.x;
	P.y -= 2. * v.y;
    }
    return P;
}

double operator +(POINT p, POINT q)
{
    double x = p.x - q.x, y = p.y - q.y;

    return sqrt(x * x + y * y);
}

double operator +(POINT p, LINE l)
{
    double d = l.a * l.a + l.b * l.b, e;

    if(d == 0.) {
	fprintf(stderr, "Error\n");
	exit(0);
    }
    e = l.a * p.x + l.b * p.y + l.c;
    if(e < 0.) e *= -1.;
    return e / sqrt(d);
}

POINT operator |(CIRC c, POINT P)
{
    POINT Q;

    if(c.r == 0.) {
        double xx = c.c.x * c.c.x, yy = c.c.y * c.c.y, xy = 2. * c.c.x * c.c.y, x2py2 = xx + yy, x2my2 = xx - yy;

	Q.x = (x2my2 * P.x + xy * P.y) / x2py2;
	Q.y = (xy * P.x - x2my2 * P.y) / x2py2;
    }
    else {
        double xx = P.x - c.c.x, yy = P.y - c.c.y, r0 = xx * xx + yy * yy, r2 = c.r * c.r;
	Q.x = c.c.x + xx * r2 / r0;
	Q.y = c.c.y + yy * r2 / r0;
    }
    return Q;
}

int operator +(CIRC c1, CIRC c2)
{
    double r, x = c1.c.x - c2.c.x, y = c1.c.y - c2.c.y;
    r = sqrt(x * x + y * y);
    if((c1.r + c2.r < r) || (c1.r + r <c2.r) || (c2.r + r < c1.r)) return 0;
    else return 1;
}

CIRC operator -(POINT P, POINT Q)
{
    double d = 2. * (P.x * Q.y - P.y * Q.x), dP = P.x * P.x + P.y * P.y + 1., dQ = Q.x * Q.x + Q.y * Q.y + 1.;
    CIRC c;

    if(d < .0000000001 && d > -.0000000001) {
        c.r = 0.;
	c.c = P;
    }
    else {
        c.c.x = (dP * Q.y - dQ * P.y) / d;
	c.c.y = (dQ * P.x - dP * Q.x) / d;
	c.r = sqrt(c.c.x * c.c.x + c.c.y * c.c.y - 1.);
    }
    return c;
}

int divide(POINT P, POINT Q, int n, POINT R[])
{
	int i;
	POINT D;

	if(n < 2) return 0;
	D.x = (Q.x - P.x) / n; D.y = (Q.y - P.y) / n;
	for(i = 1; i < n; i++) {
		R[i-1].x = P.x + i * D.x;
		R[i-1].y = P.y + i * D.y;
	}
	return n;
}
