#include <stdio.h>
#include <stdlib.h>
#include "algi.h"

typedef struct {
	AGI x, y;
} PAI;

PAI solv(AGI a, AGI b, AGI d)
{
	AGI r;
	PAI s, t;

	r = remainder(a, b);
	if(norm(r) == 0) {
		if(norm(remainder(d, b)) == 0) {
			s.x.r = s.x.w = 0; s.y = d / b;
			return s;
		}
		else {
			fprintf(stderr, "No solutions\n");
			exit(0);
		}
	}
	t = solv(b, r, d);
	s.x = t.y; s.y = t.x - ((a - r) / b) * t.y;
	return s;
}
		
int main(int argc, char *argv[])
{
	AGI a, b, d;
	PAI s;

	if(argc < 4) {
		fprintf(stderr, "Three para needed\n");
		return 0;
	}
	a = atoagi(argv[1]);
	b = atoagi(argv[2]);
	d = atoagi(argv[3]);
	if(norm(a) >= norm(b)) {
		s = solv(a, b, d);
		wtagi(s.x); printf(", "); wtagi(s.y); printf("\n");
	}
	else {
		s = solv(b, a, d);
		wtagi(s.y); printf(", "); wtagi(s.x); printf("\n");
	}
	return 0;
}

