#include <stdio.h>
#include <stdlib.h>
#include "algi.h"

AGI operator -(AGI x, AGI y)
{
	AGI z;

	z.r = x.r - y.r;
	z.w = x.w - y.w;
	return z;
}

AGI operator +(AGI x, AGI y)
{
	AGI z;

	z.r = x.r + y.r;
	z.w = x.w + y.w;
	return z;
}

AGI operator *(AGI x, AGI y)
{
	AGI z;

	z.r = x.r * y.r - x.w * y.w;
	z.w = (x.r - x.w) * y.w + x.w * y.r;
	return z;
}

AGI operator /(AGI x, AGI y)
{
	AGI z;
	long nr;

	nr = (y.r - y.w) * y.r + y.w * y.w;
	z.r = (x.r * (y.r - y.w) + x.w* y.w) / nr;
	z.w = (x.w * y.r - x.r * y.w) / nr;
	return z;
}

CPX operator /(CPX x, CPX y)
{
	CPX z;
	long nr;

	nr = (y.r - y.w) * y.r + y.w * y.w;
	z.r = (x.r * (y.r - y.w) + x.w * y.w) / nr;
	z.w = (x.w * y.r - x.r * y.w) / nr;
	return z;
}

long norm(AGI x)
{
	return (x.r - x.w) * x.r + x.w * x.w;
}

AGI atoagi(char *s)
{
    AGI z;
    char *t;
    int sgn = 1;

    t = s;
    if(*t == '-' ) {
		t++;
		if(*t == 'w') {
			sgn = -1;
			s = t;
		}
    }
    for(; *t != 0; t++) {
		if(*t == '+' || *t == '-' || *t == 'w') break;
    }
    if(*t == 0) {
		z.w = 0;
		sgn = 0;
    }
    else if(*t == '-') sgn = -1;
    if(*t == 'w' && s == t) z.r = 0;
    else {
		*t = 0;
		z.r = atoi(s);
    }
    if(sgn == 0) return z;
    if(*(++t) == 'w') t++;
    for(s = t; ; t++) if(*t == 0) break;
    if(s == t) z.w = sgn;
    else z.w = sgn * atoi(s);
    return z;
}

void wtagi(AGI a)
{
	if((a.r != 0) || (a.w == 0)) printf("%ld", a.r);
	if(a.w > 0) printf("+w%ld", a.w);
	else if(a.w < 0) printf("-w%ld", -a.w);
}
