/* z^4 = f(x, y) ɽ̤夫鸫 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .01

double ft(double x, double y)
{
    double x2 = x * x, y2 = y * y, w1, w2;

    w1 = 9. - x2 - y2; w2 = x2 * x2 - 5. * x2 + 4. + y2 * y2;
    return w1 * w2;
}

double fx(double x, double y)
{
    double x2 = x * x, y2 = y * y, w1, w2;

    w1 = 9. - x2 - y2; w2 = x2 * x2 - 5. * x2 + 4. + y2 * y2;
    return -2. * x * w2 + w1 * 2. * x * (2. * x2 - 5.);
}

double fy(double x, double y)
{
    double x2 = x * x, y2 = y * y, w1, w2;

    w1 = 9. - x2 - y2; w2 = x2 * x2 - 5. * x2 + 4. + y2 * y2;
    return -2. * y * w2 + 4. * w1 * y * y2;
}

main()
{
    double x, y, z, x0, y0, z0, gray, a, b, c, z2;

    /*
    a = .1; b = .2; c = sqrt(1. - a * a - b * b);
    */
    a = 0.; b = 0.; c = 1.;
    printf("color 0 3 3\npolygon -3.1 -3.1 -3.1 3.1 3.1 3.1 3.1 -3.1\n");
    for(x = -3.; x < 3.; x += step) {
	for(y = -3.; y < 3.; y += step) {
	    if((z2 = ft(x, y)) <= 0.) continue;
	    z2 = sqrt(z2); z = sqrt(z2);
	    x0 = .25 * fx(x, y) / (z * z2); y0 = .25 * fy(x, y) / (z* z2);
	    if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;;
	    printf("gray %f\npoint %f %f\n", gray, x, y);
	}
    }
    return 0;
}
