/* z^4 = f(x, y) ɽ̤夫鸫 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .003

double ft(double x, double y)
{
    double x2 = x * x, y2 = y * y;

    return  x2 * (1. - x2) +  y2 * (1. -  y2);
}

double fx(double x, double y)
{
    double x2 = x * x;

    return 2. * x * (1. - 2. * x2);
}

double fy(double x, double y)
{
    double y2 = y * y;

    return 2. * y * (1. - 2. * y2);
}

main()
{
    double x, y, z, x0, y0, z0, gray, a, b, c, z2;

    a = .1; b = .2; c = sqrt(1. - a * a - b * b);
    printf("color 0 3 3\npolygon -1.3 -1.2 -1.3 1.2 1.3 1.2 1.3 -1.2\n");
    printf("color 0 0 0\nText 0 20 z^4 = x^2 + y^2 - x^4 - y^4\n");
    for(x = -1.5; x < 1.5; x += step) {
	for(y = -1.5; y < 1.5; y += step) {
	    if((z2 = ft(x, y)) <= 0.) continue;
	    z2 = sqrt(z2); z = sqrt(z2);
	    x0 = .25 * fx(x, y) / (z * z2); y0 = .25 * fy(x, y) / (z * z2);
	    if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
	    printf("gray %f\npoint %f %f\n", gray, x, y);
	}
    }
    return 0;
}
