/* z^2 = f(x, y) ɽ̤夫鸫 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .005

double ft(double x, double y)
{
    double w = x * x + y * y;

    return (4. - w) * (w - 1.) * (w - 1.);
}

double fx(double x, double y)
{
    double w = x * x + y * y;

    return -6. * x * (w - 1.) * (w - 3.);
}

double fy(double x, double y)
{
    double w = x * x + y * y;

    return -6. * y * (w - 1.) * (w - 3.);
}

main()
{
    double x, y, z, x0, y0, z0, gray, a, b, c;

    a = -.3; b = -.2; c = sqrt(1. - a * a - b * b);
    printf("color 0 3 3\npolygon -2.1 -2.1 -2.1 2.1 2.1 2.1 2.1 -2.1\n");
    printf("color 0 0 0\nText 0 20 z^2 = (4 - x^2 - y^2)(x^2 + y^2 - 1)^2 & x + 7y - 2z + 6 < 0\n");
    for(x = -2.; x < 2.; x += step) {
	for(y = -2.; y < 2.; y += step) {
	    if((z = ft(x, y)) <= 0.) continue;
	    z = sqrt(z);
	    if(z > .5 * x + 3.5 * y + 3.) z *= -1.;
	    if(z > .5 * x + 3.5 * y + 3.) continue;
	    x0 = .5 * fx(x, y) / z; y0 = .5 * fy(x, y) / z;
	    if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
	    printf("gray %f\npoint %f %f\n", gray, x, y);
	}
    }
    return 0;
}
