#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "geometry.h"

main(int argc, char *argv[])
{
    P2D pts[3], mpts[3], ct;
    CIRC cr;
    LINE l[3], m[3], e[3];
    int i, j;
    double s1, s2, s, r;

    if(argc <= 6) exit(0);
    for(i = 0, j = 1; i < 3; i++) {
	pts[i].x = atof(argv[j++]);
	pts[i].y = atof(argv[j++]);
    }
    for(i = 0; i < 3; i++) {
	e[i].a = pts[(i + 1) % 3].y - pts[(i + 2) % 3].y;
	e[i].b = pts[(i + 2) % 3].x - pts[(i + 1) % 3].x;
	e[i].c = e[i].a * pts[(i + 1) % 3].x + e[i].b * pts[(i + 1) % 3].y;
	printf("line %f %f %f\n", e[i].a, e[i].b, -e[i].c);
    }
    printf("color 0 0 3\n");
    //    printf("connect %f %f %f %f %f %f %f %f\ncolor 0 0 3\n", pts[0].x, pts[0].y, pts[1].x, pts[1].y, pts[2].x, pts[2].y, pts[0].x, pts[0].y);
    for(i = 0; i < 3; i++) {
	mpts[i].x = (pts[i].x + pts[(i + 1) % 3].x) / 2.;
	mpts[i].y = (pts[i].y + pts[(i + 1) % 3].y) / 2.;
    }
    gaishin(mpts[0], mpts[1], mpts[2], &cr);
    printf("circle %f %f %f\ncolor 0 3 3\n", cr.x, cr.y, cr.r);
    for(i = 0; i < 3; i++) {
	s = atan2(pts[(i + 1) % 3].y - pts[(i + 2) % 3].y, pts[(i + 1) % 3].x - pts[(i + 2) % 3].x);
	s += M_PI / 2.;
	l[0].a = sin(s); l[0].b = -cos(s); l[0].c = l[0].a * pts[i].x + l[0].b * pts[i].y;
	/*
	printf("line %f %f %f\n", l[0].a, l[0].b, -l[0].c);
	l[1].a = pts[(i + 1) % 3].y - pts[(i + 2) % 3].y;
	l[1].b = pts[(i + 2) % 3].x - pts[(i + 1) % 3].x;
	l[1].c = l[1].a * pts[(i + 1) % 3].x + l[1].b * pts[(i + 1) % 3].y;
	*/
	kouten(l[0], e[i], mpts + i);
	printf("connect %f %f %f %f\n", pts[i].x, pts[i].y, mpts[i].x, mpts[i].y);
    }
    for(i = 0; i < 3; i++) {
	s1 = atan2(pts[(i + 1) % 3].y - pts[i].y, pts[(i + 1) % 3].x - pts[i].x);
	if(s1 < 0.) s1 += 2. * M_PI;
	s2 = atan2(pts[(i + 2) % 3].y - pts[i].y, pts[(i + 2) % 3].x - pts[i].x);
	if(s2 < 0.) s2 += 2. * M_PI;
	s = (s1 + s2) / 2.;
	l[i].a = sin(s); l[i].b = -cos(s); l[i].c = l[i].a * pts[i].x + l[i].b * pts[i].y;
	if(s < M_PI / 2.) s += M_PI / 2.;
	else s -= M_PI / 2.;
	m[i].a = sin(s); m[i].b = -cos(s); m[i].c = m[i].a * pts[i].x + m[i].b * pts[i].y;
	//	printf("line %f %f %f\n", m[i].a, m[i].b, -m[i].c);
    }
    kouten(l[0], l[1], &ct);
    r = (e[0].a * ct.x + e[0].b * ct.y - e[0].c) / sqrt(e[0].a * e[0].a + e[0].b * e[0].b);
    if(r < 0.) r *= -1.;
    printf("color 3 0 0\ncircle %f %f %f\n", ct.x, ct.y, r);
    for(i = 0; i < 3; i++) {
	kouten(l[i], m[(i + 1) % 3], &ct);
	r = (e[i].a * ct.x + e[i].b * ct.y - e[i].c) / sqrt(e[i].a * e[i].a + e[i].b * e[i].b);
	if(r < 0.) r *= -1.;
	printf("circle %f %f %f\n", ct.x, ct.y, r);
    }
    return 0;
}
