/*
f(x, y, z) = 0 ɽ̤夫鸫
f(x, y, z) = f_0(x, y)z^d + ... + f_d-1(x, y)z + f_d(x, y) 
ΤȤؿ ft()  c[i]  f_i(x, y) ,
fdallsol(d, c, zz) Ȥ
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .01
#define gosa .0000001
#define MAXD 10

double c[MAXD], zz[MAXD], xx[MAXD];

double solvae(int degree, double c[])
{
	int i, m = 0;
	double x0 = 1., f, df;

	for(; m < 100; m++) {
		for(i = 1, xx[0] = 1.; i <= degree; i++) xx[i] = xx[i - 1] * x0;
		for(i = 1, f = c[degree]; i <= degree; i++) f += xx[i] * c[degree - i];
		if(f < gosa && f > -gosa) return x0;
		for(i = 1, df = c[degree - 1]; i < degree; i++) df += (i + 1) * xx[i] * c[degree - i - 1];
		if(df < gosa && df > -gosa) break;
		f /= df;
		if(f < gosa && f > -gosa) return x0;
		x0 -= f;
	}
	return 1000001.;
}

int fdallsol(int degree, double c[], double zz[])
{
	int i, n;

	for(n = 0; c[degree] == 0.; degree--, n++) zz[n] = 0.;
	for(; degree > 0; degree--, n++) {
		if((zz[n] = solvae(degree, c)) > 1000000.) break;
		for(i = 1; i < degree; i++) {
			c[i] += zz[n] * c[i - 1];
		}
	}
	return n;
}

double ft(double x, double y)
{
    int i, n;
    double x2 = x * x, y2 = y * y, z;

    c[0] = 1.; c[1] = c[3] = 0.; c[2] = 2. * (x2 + y2 + 6.);
    c[4] = (x2 - 10.) * x2 + (y2 - 10.) * y2 + 2. * x2 * y2 + 9.;
    if((n = fdallsol(4, c, zz)) == 0) return 1001.;
    for(z = zz[0], i = 1; i < n; i++) if(z < zz[i]) z = zz[i];
    return z;
}

double dzdx(double x, double y, double z)
{
    double x2 = x * x, y2 = y * y, z2 = z * z;

    return -x * (x2 + y2 + z2 - 5.) / (z * (z2 + x2 + y2 + 3.));
}

double dzdy(double x, double y, double z)
{
    double x2 = x * x, y2 = y * y, z2 = z * z;

    return -y * (x2 + y2 + z2 - 5.) / (z * (z2 + x2 + y2 + 3.));
}

main()
{
    double x, y, z, x0, y0, z0, gray, a, b, c, z2;

    a = .1; b = .3; c = sqrt(1. - a * a - b * b);
    printf("color 0 3 3\npolygon -3.3 -3.2 -3.3 3.2 3.3 3.2 3.3 -3.2\n");
    printf("color 0 0 0\nText 0 20 x^4 + y^4 + z^4 + 2x^2y2 + 2y^2z^2 + 2z^2x^2 - 10x^2 - 10y^2 + 6z^2 + 9 = 0\n");
    for(x = -3.1; x < 3.1; x += step) {
	for(y = -3.1; y < 3.1; y += step) {
	    if((z = ft(x, y)) > 1000.) continue;
	    x0 = dzdx(x, y, z); y0 = dzdy(x, y, z);
	    if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
	    printf("gray %f\npoint %f %f\n", gray, x, y);
	}
    }
    return 0;
}
