/*
f(x, y, z) = 0 ɽ̤ z 鸫
f(x, y, z) = f_0(x, y)z^d + ... + f_d-1(x, y)z + f_d(x, y) 
ΤȤؿ main()  c[i]  f_i(x, y) ,
ؿ fdallsol(d, c, zz) Ƥ֤Ȥΰ d  f  z ˴ؤ뼡Ȥ
ؿ dzdx  dz/dx ֤ͤ褦
ؿ dzdy  dz/dy ֤ͤ褦
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .003
#define gosa .0000001
#define MAXD 10
#define MINZ -10001.
#define MAXNOFP 1000000

double cc[MAXD], zz[MAXD], xx[MAXD];
struct PT {
  double x, y, z, g;
} points[MAXNOFP];
int nofpt = 0, order[MAXNOFP];

double solvae(int degree, double c[], double x0)
{
	int i, m = 0;
	double f, df;

	for(; m < 100; m++) {
		for(i = 1, xx[0] = 1.; i <= degree; i++) xx[i] = xx[i - 1] * x0;
		for(i = 1, f = c[degree]; i <= degree; i++) f += xx[i] * c[degree - i];
		if(f < gosa && f > -gosa) return x0;
		for(i = 1, df = c[degree - 1]; i < degree; i++) df += (i + 1) * xx[i] * c[degree - i - 1];
		if(df < gosa && df > -gosa) break;
		f /= df;
		if(f < gosa && f > -gosa) return x0;
		x0 -= f;
	}
	return 1000001.;
}

int fdallsol(int degree, double c[], double zz[])
{
	int i, n;

	for(n = 0; c[degree] == 0.; degree--, n++) zz[n] = 0.;
	for(; degree > 0; degree--, n++) {
		if((zz[n] = solvae(degree, c, 1.)) > 1000000. && (zz[n] = solvae(degree, c, -1.)) > 1000000.) break;
		for(i = 1; i < degree; i++) {
			c[i] += zz[n] * c[i - 1];
		}	
	}
	return n;
}

double dzdx(double x, double y, double z)
{
    double x2 = x * x, z2 = z * z;

    return - x * (((2. * x2 - 6.) * x2 + 5.) * x2 - 1.) / (z * (((2. * z2 - 6.) * z2 + 5.) * z2 - 1.));
}

double dzdy(double x, double y, double z)
{
    double z2 = z * z;

    return -y / (2. * z * (((2. * z2 - 6.) * z2 + 5.) * z2 - 1.));
}

main()
{
    int j, i, n;
    double x, y, z, x0, y0, z0, gray, a, b, c, z2;

    a = .1; b = .2; c = sqrt(1. - a * a - b * b);
    printf("gray .5\n");
    for(x = -1.4; x <= 1.4; x += .2) printf("connect %f -.8 %f .8\n", x, x);
    for(y = -.8; y <= .8; y += .2) printf("connect -1.4 %f 1.4 %f\n", y, y);
    printf("gray 0.\nconnect -1.6 0. 1.6 0.\nconnect 0. -1. 0. 1.\ntext 1.8 0.01 x\n");
    printf("gray 0.\nText 0 20 x^8 + y^8 -4x^6 -4y^6 + 5x^4 + 5y^4 - 2x^2 - 2y^2 + z^2 = 0\n");
    for(x = -.4; x < .4; x += step) {
	double x2 = x * x;
	for(y = -.1; y < .1; y += step) {
	    double y2 = y * y;
	    cc[1] = cc[3] = cc[5] = cc[7] = 0.;
	    cc[0] = 1.; cc[2] = -4.; cc[4] = 5.; cc[6] = -2.;
	    cc[8] = (((x2 - 4.) * x2 + 5.) * x2 - 2.) * x2 + y2;
	    printf("%fx8+%fx7+%fx6+%fx5+%fx4+%fx3+%fx2+%fx+%f\n", cc[0], cc[1], cc[2], cc[3], cc[4], cc[5], cc[6], cc[7], cc[8]);
	    n = fdallsol(8, cc, zz);
	    for(i = 0; i < n; i++) {
	        int low = 0, high = nofpt, middle = 0;
		if(nofpt > 0) for( ; ; ) {
		    middle = (low + high) / 2;
		    if(low >= middle) {
		        if(zz[i] > points[order[middle]].z) middle++;
			break;
		    }
		    if(zz[i] < points[order[middle]].z) high = middle;
		    else low = middle;
		}
		for(j = nofpt; j > middle; j--) {
		  order[j] = order[j - 1];
		}
		points[nofpt].x = x;
		points[nofpt].y = y;
		points[nofpt].z = zz[i];
		x0 = dzdx(x, y, zz[i]); y0 = dzdy(x, y, zz[i]);
		if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
		points[nofpt].g = gray;
		order[middle] = nofpt;
		nofpt++;
		if(nofpt == MAXNOFP) break;
	    }
	    if(nofpt == MAXNOFP) break;
	}
	if(nofpt == MAXNOFP) break;
    }
    printf("pause\n");
    for(i = 0; i < nofpt; i++) {
        j = order[i];
        printf("gray %f\npoint %f %f %f\n", points[j].g, points[j].x, points[j].y, points[j].z);
    }
    return 0;
}
