/*
f(x, y, z) = 0 ɽ̤ z 鸫
f(x, y, z) = f_0(x, z)y^d + ... + f_d-1(x, z)y + f_d(x, z) 
ΤȤ c[i]  f_i(x, z) ,
ؿ fdallsol(d, c, yy) Ƥ֤Ȥΰ d  f  y ˴ؤ뼡Ȥ
f(x, y, z) = f_0(y, z)x^d + ... + f_d-1(y, z)x + f_d(y, z) 
ΤȤ c[i]  f_i(y, z) ,
ؿ fdallsol(d, c, xx) Ƥ֤Ȥΰ d  f  x ˴ؤ뼡Ȥ
ؿ dzdx  dz/dx ֤ͤ褦
ؿ dzdy  dz/dy ֤ͤ褦
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define step .003
#define gosa .0000001
#define MAXD 10

double cc[MAXD], zz[MAXD], yy[MAXD], xx[MAXD];

double solvae(int degree, double cc[], double x0)
{
	int i, m = 0;
	double f, df;

	for(; m < 100; m++) {
		for(i = 1, zz[0] = 1.; i <= degree; i++) zz[i] = zz[i - 1] * x0;
		for(i = 1, f = cc[degree]; i <= degree; i++) f += zz[i] * cc[degree - i];
		if(f < gosa && f > -gosa) return x0;
		for(i = 1, df = cc[degree - 1]; i < degree; i++) df += (i + 1) * zz[i] * cc[degree - i - 1];
		if(df < gosa && df > -gosa) break;
		f /= df;
		if(f < gosa && f > -gosa) return x0;
		x0 -= f;
	}
	return 1000001.;
}

int fdallsol(int degree, double cc[], double xx[])
{
	int i, n;

	for(n = 0; cc[degree] == 0.; degree--, n++) xx[n] = 0.;
	for(; degree > 0; degree--, n++) {
		if((xx[n] = solvae(degree, cc, 1.)) > 1000000. && (xx[n] = solvae(degree, cc, -1.)) > 1000000.) break;
		for(i = 1; i < degree; i++) {
			cc[i] += xx[n] * cc[i - 1];
		}	
	}
	return n;
}

double dzdx(double x, double y, double z)
{
    double x2 = x * x, x4 = x2 * x2, z2 = z * z, z4 = z2 * z2;

    return -x * (6. * z4 + 12. * (x2 - 2.) * z2 + 6. * (x4 - 4. * x2 + 3.)) / (z * (6. * z4 + 12. * (x2 - 2.) * z2 + 6. * (x4 - 4. * x2 + 3.)));
}

double dzdy(double x, double y, double z)
{
    double x2 = x * x, x4 = x2 * x2, z2 = z * z, z4 = z2 * z2;

    return -2. * y / (z * (6. * z4 + 12. * (x2 - 2.) * z2 + 6. * (x4 - 4. * x2 + 3.)));
}

main()
{
    int j, i, n;
    double x, y, z, x0, y0, z0, x2, y2, z2, x4, z4, gray, a, b, c;

    a = .1; b = .2; c = sqrt(1. - a * a - b * b);
    printf("gray 0.\nText 0 20 (x^2 + y^2 - 1)^2(x^2 + y^2 -4) + z^2 = 0\n");
    for(z = -2.; z < 2.; z += step * 3.) {
        /*
        printf("gray 0.\nText 0 50 %.2f\n", z);
        */
        z2 = z * z; z4 = z2 * z2;
	for(y = -2.; y < 2.; y += step) {
	    y2 = y * y;
	    cc[0] = 1.; cc[1] = cc[3] = cc[5] = 0.;
	    cc[2] = 3. * (z2 - 2.); cc[4] = 3. * (z4 - 4. * z2 + 3.);
	    cc[6] = z2 * (z4 - 6. * z2 + 9.) - 4. + y2;
	    n = fdallsol(6, cc, xx);
	    for(i = 0; i < n; i++) {
	        x = xx[i];
		x0 = dzdx(x, y, z); y0 = dzdy(x, y, z);
		if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
		printf("gray %f\npoint %f %f\n", gray, x, y);
	    }
	}
	for(x = -2.; x < 2.; x += step) {
	  x2 = x * x; x4 = x2 * x2;
	    cc[0] = 1.; cc[1] = 0.; 
	    cc[2] = x2 * (x4 + 3. * (z2 - 2.) * x2 + 3. * (z4 - 4. * z2 + 3.)) + z2 * (z4 - 6. * z2 + 9.) - 4.;
	    n = fdallsol(2, cc, yy);
	    for(i = 0; i < n; i++) {
	        y = yy[i];
		x0 = dzdx(x, y, z); y0 = dzdy(x, y, z);
		if((gray = (-a * x0 - b * y0 + c) / sqrt(1. + x0 * x0 + y0 * y0)) < .0) gray = 0.;
		printf("gray %f\npoint %f %f\n", gray, x, y);
	    }
	}
    }
    return 0;
}
