#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define GOSA .00001

typedef struct eqnofline {
	double a, b, c;
} eql;
typedef struct point {
	double x, y;
} PT;

int fdallsol(int n, double c[], double d[]);
eql eq[4], eq0;
PT point[3];
double st[4], c[6], d[6], cc[4], z[2];

void coniceq(eql l1, eql l2, double c[])
{
    c[0] = l1.a * l2.a;
    c[1] = l1.a * l2.b + l2.a * l1.b;
    c[2] = l1.b * l2.b;
    c[3] = l1.a * l2.c + l2.a * l1.c;
    c[4] = l1.b * l2.c + l2.b * l1.c;
    c[5] = l1.c * l2.c;
    return ;
}

int kouten(eql l1, eql l2, PT *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.b * l2.c - l2.b * l1.c) / d;
    (*p).y = (l1.c * l2.a - l2.c * l1.a) / d;
    return 1;
}

int ptline(PT p1, PT p2, eql *l)
{
    double dx;

    if(((dx = p1.x - p2.x) < GOSA) && (dx > -GOSA)) {
	(*l).a = 1.; (*l).b = 0.; (*l).c = -p1.x;
    }
    else {
	(*l).a = p1.y - p2.y;
	(*l).b = p2.x - p1.x;
	(*l).c = p1.x * p2.y - p2.x * p1.y;
    }
    return 1;
}

main(int argc, char *argv[])
{
    int i, j, n, adp = 1;
    double ab, cb, ca, a2b2, sqa2b2, x, y, t;
    PT pt1, pt2;
    eql l0;

    if(argc < 5) exit(0);
    for(i = 0; i < 4; i++) {
	st[i] = atof(argv[i + 1]);
	eq[i].a = cos(st[i]);
	eq[i].b = sin(st[i]);
	eq[i].c = -1.;
    }
    printf("circle 0 0 1\ncolor 1 3 1\n");
    for(i = 0; i < 4; i++) {
	printf("line %f %f %f\n", eq[i].a, eq[i].b, eq[i].c);
    }
    coniceq(eq[0], eq[2], c);
    coniceq(eq[1], eq[3], d);
    for(i = 0; i < 6; i++) c[i] += d[i];
    kouten(eq[0], eq[2], &pt1);
    kouten(eq[1], eq[3], &pt2);
    ptline(pt1, pt2, &l0);
    printf("color 0 0 3\n");
//    printf("gray 0.\n");
    printf("curve %fx2+%fxy+%fy2+%fx+%fy+%f\nline %f %f %f\n", c[0], c[1], c[2], c[3], c[4], c[5], l0.a, l0.b, l0.c);
    printf("pause\ncolor 3 0 0\n");
    for(t = st[0]; t < st[1]; t += .002) {
	eq0.a = cos(t); eq0.b = sin(t); eq0.c = -1.;
	if((eq0.b < GOSA) && (eq0.b > -GOSA)) {
	    ca = -eq0.c / eq0.a;
	    cc[0] = c[2];
	    cc[1] = c[1] * ca + c[4];
	    cc[2] = (c[0] * ca + c[3]) * ca + c[5];
	    n = fdallsol(2, cc, z);
	    for(i = 0; i < n; i++) {
		point[i].x = ca;
		point[i].y = z[i];
	    }
	}
	else {
	    ab = -eq0.a / eq0.b; cb = -eq0.c / eq0.b;
	    cc[0] = c[0] + ab * (c[1] + ab * c[2]);
	    cc[1] = c[3] + ab * c[4] + cb *(c[1] + 2 * ab * c[2]);
	    cc[2] = c[5] + cb * (cb * c[2] + c[4]);
	    n = fdallsol(2, cc, z);
	    for(i = 0; i < n; i++) {
		point[i].x = z[i];
		point[i].y = ab * z[i] + cb;
	    }
	}
	kouten(eq0, l0, point + n);
	n++;
	printf("active %d\ncopy 0 %d\n", adp, adp);
	printf("line %f %f %f\n", eq0.a, eq0.b, eq0.c);
	for(i = 0; i < n; i++) {
	    x = point[i].x; y = point[i].y;
	    a2b2 = x * x + y * y;
	    sqa2b2 = sqrt(a2b2 - 1.);
	    printf("line %f %f %f\n", x + y * sqa2b2, y - x * sqa2b2, -a2b2);
	    printf("line %f %f %f\n", x - y * sqa2b2, y + x * sqa2b2, -a2b2);
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
