#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define GOSA .00001

typedef struct eqnofline {
	double a, b, c;
} eql;
typedef struct point {
	double x, y;
} PT;

eql eq[4], eq0, ln[3];
PT point[3];
double st[4];

int kouten(eql l1, eql l2, PT *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.b * l2.c - l2.b * l1.c) / d;
    (*p).y = (l1.c * l2.a - l2.c * l1.a) / d;
    return 1;
}

int ptline(PT p1, PT p2, eql *l)
{
    double dx;

    if(((dx = p1.x - p2.x) < GOSA) && (dx > -GOSA)) {
	(*l).a = 1.; (*l).b = 0.; (*l).c = -p1.x;
    }
    else {
	(*l).a = p1.y - p2.y;
	(*l).b = p2.x - p1.x;
	(*l).c = p1.x * p2.y - p2.x * p1.y;
    }
    return 1;
}

main(int argc, char *argv[])
{
    int i, j, n, adp = 1;
    double ab, cb, ca, a2b2, sqa2b2, x, y, t;
    PT pt1, pt2;

    if(argc < 5) exit(0);
    for(i = 0; i < 4; i++) {
	st[i] = atof(argv[i + 1]);
	eq[i].a = cos(st[i]);
	eq[i].b = sin(st[i]);
	eq[i].c = -1.;
    }
    printf("circle 0 0 1\ncolor 1 3 1\n");
    for(i = 0; i < 4; i++) {
	printf("line %f %f %f\n", eq[i].a, eq[i].b, eq[i].c);
    }
    kouten(eq[0], eq[2], &pt1);
    kouten(eq[1], eq[3], &pt2);
    ptline(pt1, pt2, ln);
    kouten(eq[0], eq[1], &pt1);
    kouten(eq[2], eq[3], &pt2);
    ptline(pt1, pt2, ln + 1);
    kouten(eq[0], eq[3], &pt1);
    kouten(eq[1], eq[2], &pt2);
    ptline(pt1, pt2, ln + 2);
    printf("color 0 0 3\n");
    for(i = 0; i < 3; i++) printf("line %f %f %f\n", ln[i].a, ln[i].b, ln[i].c);
    printf("pause\ncolor 3 0 0\n");
    for(t = 0.; t < M_PI; t += .002) {
	eq0.a = cos(t); eq0.b = sin(t); eq0.c = -1.;
	for(i = 0; i < 3; i++) kouten(eq0, ln[i], point + i);
	printf("active %d\ncopy 0 %d\n", adp, adp);
	printf("line %f %f %f\n", eq0.a, eq0.b, eq0.c);
	for(i = 0; i < 3; i++) {
	    x = point[i].x; y = point[i].y;
	    a2b2 = x * x + y * y;
	    sqa2b2 = sqrt(a2b2 - 1.);
	    printf("line %f %f %f\n", x + y * sqa2b2, y - x * sqa2b2, -a2b2);
	    printf("line %f %f %f\n", x - y * sqa2b2, y + x * sqa2b2, -a2b2);
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
