#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct eqnofline {
	double a, b, c;
} eql;
typedef struct point {
	double x, y;
} PT;

eql eq[6];
double st[4], c[10], d[10];

void cubiceq(eql l1, eql l2, eql l3, double c[])
{
    c[0] = l1.a * l2.a * l3.a;
    c[1] = l1.a * (l2.a * l3.b + l2.b * l3.a) + l1.b * l2.a * l3.a;
    c[2] = l1.a * l2.b * l3.b + l1.b * (l2.a * l3.b + l2.b * l3.a);
    c[3] = l1.b * l2.b * l3.b;
    c[4] = l1.a * (l2.a * l3.c + l2.c * l3.a) + l1.c * l2.a * l3.a;
    c[5] = l1.a * l2.b * l3.c + l1.a * l2.c * l3.b + l1.b * l2.a * l3.c + l1.b * l2.c * l3.a + l1.c * l2.a * l3.b + l1.c * l2.b * l3.a;
    c[6] = l1.b * (l2.b * l3.c + l2.c * l3.b) + l1.c * l2.b * l3.b;
    c[7] = l1.a * l2.c * l3.c + l1.c * (l2.a * l3.c + l2.c * l3.a);
    c[8] = l1.b * l2.c * l3.c + l1.c * (l2.b * l3.c + l2.c * l3.b);
    c[9] = l1.c * l2.c * l3.c;
    return ;
}

main(int argc, char *argv[])
{
    int i, j;

    if(argc < 5) exit(0);
    for(i = 0; i < 4; i++) {
	st[i] = atof(argv[i + 1]);
	eq[i].a = cos(st[i]);
	eq[i].b = sin(st[i]);
	eq[i].c = -1.;
    }
    printf("circle 0 0 1\ncolor 0 0 3\n");
    for(i = 0; i < 4; i++) {
	printf("line %f %f %f\n", eq[i].a, eq[i].b, eq[i].c);
    }
    eq[5].a = eq[0].a + .3 * eq[1].a; eq[5].b = eq[0].b + .3 * eq[1].b; eq[5].c = eq[0].c + .3 * eq[1].c;
    eq[4].a = eq[2].a + eq[3].a; eq[4].b = eq[2].b + eq[3].b; eq[4].c = eq[2].c + eq[3].c;
    cubiceq(eq[0], eq[1], eq[4], c);
    cubiceq(eq[2], eq[3], eq[5], d);
    for(i = 0; i < 10; i++) c[i] -= .5 * d[i];
    printf("color 3 0 0\n");
    //    printf("gray 0.\n");
    printf("curve %fx3+%fx2y+%fxy2+%fy3+%fx2+%fxy+%fy2+%fx+%fy+%f\n", c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7], c[8], c[9]);
    return 0;
}
