#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct eqnofline {
	double a, b, c;
} LINE;

typedef struct point {
	double x, y;
} P2D;

LINE l[3], m[3];
double c[10], d[10];

int kouten(LINE l1, LINE l2, P2D *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.c * l2.b - l2.c * l1.b) / d;
    (*p).y = (l1.a * l2.c - l2.a * l1.c) / d;
    return 1;
}


void cubiceq(LINE l1, LINE l2, LINE l3, double c[])
{
    c[0] = l1.a * l2.a * l3.a;
    c[1] = l1.a * (l2.a * l3.b + l2.b * l3.a) + l1.b * l2.a * l3.a;
    c[2] = l1.a * l2.b * l3.b + l1.b * (l2.a * l3.b + l2.b * l3.a);
    c[3] = l1.b * l2.b * l3.b;
    c[4] = -l1.a * (l2.a * l3.c + l2.c * l3.a) - l1.c * l2.a * l3.a;
    c[5] = -l1.a * l2.b * l3.c - l1.a * l2.c * l3.b - l1.b * l2.a * l3.c - l1.b * l2.c * l3.a - l1.c * l2.a * l3.b - l1.c * l2.b * l3.a;
    c[6] = -l1.b * (l2.b * l3.c + l2.c * l3.b) - l1.c * l2.b * l3.b;
    c[7] = l1.a * l2.c * l3.c + l1.c * (l2.a * l3.c + l2.c * l3.a);
    c[8] = l1.b * l2.c * l3.c + l1.c * (l2.b * l3.c + l2.c * l3.b);
    c[9] = -l1.c * l2.c * l3.c;
    return ;
}

main(int argc, char *argv[])
{
    int i, j;
    double sqr3, sqr2, x1, y1, x2y2, s;
    P2D pt;

    if(argc > 1) s = atof(argv[1]);
    else s = 1.;
    sqr3 = sqrt(3.);
    sqr2 = sqrt(2.);
    printf("circle 0 0 1.\ncolor 3 0 0\ncurve x2-y2+2x\ncolor 0 0 3\n");
    l[0].a = 1.; l[0].b = 0.; l[0].c = 1.;
    l[1].a = 1.; l[1].b = sqr3; l[1].c = -2.;
    l[2] = l[1]; l[2].b *= -1.;
    m[0].a = 0.; m[0].b = 1.; m[0].c = -1.;
    x1 = -1. + sqr2; y1 = -1.;
    x2y2 = x1 * x1 + y1 * y1;
    m[1].a = (x1 - y1 * sqrt(x2y2 - 1.)) / x2y2;
    m[1].b = (1. - m[1].a * x1) / y1; m[1].c = 1.;
    x1 = -1. - sqr2;
    x2y2 = x1 * x1 + y1 * y1;
    m[2].a = (x1 + y1 * sqrt(x2y2 - 1.)) / x2y2;
    m[2].b = (1. - m[2].a * x1) / y1; m[2].c = 1.;
    for(i = 0; i < 3; i++) printf("line %f %f %f\n", l[i].a, l[i].b, -l[i].c);
    printf("color 0 3 0\n");
    for(i = 0; i < 3; i++) printf("line %f %f %f\n", m[i].a, m[i].b, -m[i].c);
    /*
    for(i = 0; i < 3; i++) {
	for(j = 0; j < 3; j++) {
	    kouten(l[i], m[j], &pt);
	    fprintf(stderr, "%f %f\n", pt.x, pt.y);
	}
    }
    */
    cubiceq(l[0], l[1], l[2], c);
    cubiceq(m[0], m[1], m[2], d);
    for(i = 0; i < 10; i++) c[i] += s * d[i];
    printf("color 3 2 0\ncurve %fx3+%fx2y+%fxy2+%fy3+%fx2+%fxy+%fy2+%fx+%fy+%f\n", c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7], c[8], c[9]);
    return 0;
}
