#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct eqnofline {
	double a, b, c;
} LINE;

typedef struct point {
	double x, y;
} P2D;

LINE l[3], m[3], n[3];
double f[10], g[10], h[10], fg[28], gh[28], hf[28];

int kouten(LINE l1, LINE l2, P2D *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.c * l2.b - l2.c * l1.b) / d;
    (*p).y = (l1.a * l2.c - l2.a * l1.c) / d;
    return 1;
}


void cubiceq(LINE l1, LINE l2, LINE l3, double c[])
{
    c[0] = l1.a * l2.a * l3.a;
    c[1] = l1.a * (l2.a * l3.b + l2.b * l3.a) + l1.b * l2.a * l3.a;
    c[2] = l1.a * l2.b * l3.b + l1.b * (l2.a * l3.b + l2.b * l3.a);
    c[3] = l1.b * l2.b * l3.b;
    c[4] = -l1.a * (l2.a * l3.c + l2.c * l3.a) - l1.c * l2.a * l3.a;
    c[5] = -l1.a * l2.b * l3.c - l1.a * l2.c * l3.b - l1.b * l2.a * l3.c - l1.b * l2.c * l3.a - l1.c * l2.a * l3.b - l1.c * l2.b * l3.a;
    c[6] = -l1.b * (l2.b * l3.c + l2.c * l3.b) - l1.c * l2.b * l3.b;
    c[7] = l1.a * l2.c * l3.c + l1.c * (l2.a * l3.c + l2.c * l3.a);
    c[8] = l1.b * l2.c * l3.c + l1.c * (l2.b * l3.c + l2.c * l3.b);
    c[9] = -l1.c * l2.c * l3.c;
    return ;
}

void multp(double f[], double g[], double fg[])
{
    fg[0] = f[0] * g[0];
    fg[1] = f[0] * g[1] + f[1] * g[0];
    fg[2] = f[0] * g[2] + f[1] * g[1] + f[2] * g[0];
    fg[3] = f[0] * g[3] + f[1] * g[2] + f[2] * g[1] + f[3] * g[0];
    fg[4] = f[1] * g[3] + f[2] * g[2] + f[3] * g[1];
    fg[5] = f[2] * g[3] + f[3] * g[2];
    fg[6] = f[3] * g[3];
    fg[7] = f[0] * g[4] + f[4] * g[0];
    fg[8] = f[0] * g[5] + f[5] * g[0] + f[1] * g[4] + f[4] * g[1];
    fg[9] = f[0] * g[6] + f[6] * g[0] + f[1] * g[5] + f[5] * g[1] + f[2] * g[4] + f[4] * g[2];
    fg[10] = f[1] * g[6] + f[6] * g[1] + f[2] * g[5] + f[5] * g[2] + f[3] * g[4] + f[4] * g[3];
    fg[11] = f[2] * g[6] + f[6] * g[2] + f[3] * g[5] + f[5] * g[3];
    fg[12] = f[3] * g[6] + f[6] * g[3];
    fg[13] = f[0] * g[7] + f[7] * g[0] + f[4] * g[4];
    fg[14] = f[0] * g[8] + f[8] * g[0] + f[1] * g[7] + f[7] * g[1] + f[4] * g[5] + f[5] * g[4];
    fg[15] = f[1] * g[8] + f[8] * g[1] + f[2] * g[7] + f[7] * g[2] + f[4] * g[6] + f[5] * g[5] + f[6] * g[4];
    fg[16] = f[2] * g[8] + f[8] * g[2] + f[3] * g[7] + f[7] * g[3] + f[5] * g[6] + f[6] * g[5];
    fg[17] = f[3] * g[8] + f[8] * g[3] + f[6] * g[6];
    fg[18] = f[0] * g[9] + f[9] * g[0] + f[4] * g[7] + f[7] * g[4];
    fg[19] = f[1] * g[9] + f[9] * g[1] + f[4] * g[8] + f[8] * g[4] + f[5] * g[7] + f[7] * g[5];
    fg[20] = f[2] * g[9] + f[9] * g[2] + f[5] * g[8] + f[8] * g[5] + f[6] * g[7] + f[7] * g[6];
    fg[21] = f[3] * g[9] + f[9] * g[3] + f[6] * g[8] + f[8] * g[6];
    fg[22] = f[4] * g[9] + f[9] * g[4] + f[7] * g[7];
    fg[23] = f[5] * g[9] + f[9] * g[5] + f[7] * g[8] + f[8] * g[7];
    fg[24] = f[6] * g[9] + f[9] * g[6] + f[8] * g[8];
    fg[25] = f[7] * g[9] + f[9] * g[7];
    fg[26] = f[8] * g[9] + f[9] * g[8];
    fg[27] = f[9] * g[9];
}

main(int argc, char *argv[])
{
    int i, j;
    double sqr3, sqr2, x1, y1, x2y2, s, t;
    P2D pt;

    if(argc > 1) s = atof(argv[1]);
    else s = 1.;
    if(argc > 2) t = atof(argv[2]);
    else t = 1.;
    sqr3 = sqrt(3.);
    sqr2 = sqrt(2.);
    printf("circle 0 0 1.\ncolor 3 0 0\ncurve x2-y2+2x\ncolor 0 0 3\n");
    l[0].a = 1.; l[0].b = 0.; l[0].c = 1.;
    l[1].a = 1.; l[1].b = sqr3; l[1].c = -2.;
    l[2] = l[1]; l[2].b *= -1.;
    m[0].a = 0.; m[0].b = 1.; m[0].c = -1.;
    x1 = -1. + sqr2; y1 = -1.;
    x2y2 = x1 * x1 + y1 * y1;
    m[1].a = (x1 - y1 * sqrt(x2y2 - 1.)) / x2y2;
    m[1].b = (1. - m[1].a * x1) / y1; m[1].c = 1.;
    x1 = -1. - sqr2;
    x2y2 = x1 * x1 + y1 * y1;
    m[2].a = (x1 + y1 * sqrt(x2y2 - 1.)) / x2y2;
    m[2].b = (1. - m[2].a * x1) / y1; m[2].c = 1.;
    for(i = 0; i < 3; i++) printf("line %f %f %f\n", l[i].a, l[i].b, -l[i].c);
    printf("color 0 1 2\n");
    for(i = 0; i < 3; i++) printf("line %f %f %f\n", m[i].a, m[i].b, -m[i].c);
    for(i = 0; i < 3; i++) {
	n[i] = m[i];
	n[i].b *= -1;
    }
    printf("color 0 2 1\n");
    for(i = 0; i < 3; i++) printf("line %f %f %f\n", n[i].a, n[i].b, -n[i].c);
    cubiceq(l[0], l[1], l[2], f);
    cubiceq(m[0], m[1], m[2], g);
    cubiceq(n[0], n[1], n[2], h);
    multp(f, g, fg);
    multp(h, g, gh);
    multp(f, h, hf);
    for(i = 0; i < 28; i++) fg[i] += s * gh[i] + t * hf[i];
    printf("color 3 2 0\ncurve %fx6+%fx5y+%fx4y2+%fx3y3+%fx2y4+%fxy5+%fy6+%fx5+%fx4y+%fx3y2+%fx2y3+%fxy4+%fy5+%fx4+%fx3y+%fx2y2+%fxy3+%fy4+%fx3+%fx2y+%fxy2+%fy3+%fx2+%fxy+%fy2+%fx+%fy+%f\n", fg[0], fg[1], fg[2], fg[3], fg[4], fg[5], fg[6], fg[7], fg[8], fg[9], fg[10], fg[11], fg[12], fg[13], fg[14], fg[15], fg[16], fg[17], fg[18], fg[19], fg[20], fg[21], fg[22], fg[23], fg[24], fg[25], fg[26], fg[27]);
    return 0;
}
