#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct line {
    double a, b, c;
} LINE;

typedef struct pointin2d {
    double x, y;
} P2D;

typedef struct circle {
    double x, y, r;
} CIRC;

int kouten(LINE l1, LINE l2, P2D *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.c * l2.b - l2.c * l1.b) / d;
    (*p).y = (l1.a * l2.c - l2.a * l1.c) / d;
    return 1;
}

void gaishin(P2D pt1, P2D pt2, P2D pt3, CIRC *pt0)
{
    double d, x, y, a11, a12, a21, a22, b1, b2;

    a11 = pt1.x - pt2.x;
    a12 = pt1.y - pt2.y;
    b1 = (pt1.y * pt1.y - pt2.y * pt2.y + pt1.x * pt1.x - pt2.x * pt2.x) / 2.;
    a21 = pt1.x - pt3.x;
    a22 = pt1.y - pt3.y;
    b2 = (pt1.y * pt1.y - pt3.y * pt3.y + pt1.x * pt1.x - pt3.x * pt3.x) / 2.;
    if((d = a11 * a22 - a12 * a21) == 0.) exit(0);
    (*pt0).x = (b1 * a22 - b2 * a12) / d;
    (*pt0).y = (a11 * b2 - a21 * b1) / d;
    x = pt1.x - (*pt0).x;
    y = pt1.y - (*pt0).y;
    (*pt0).r = sqrt(x * x + y * y);
}

main(int argc, char *argv[])
{
    LINE l[5], m[2];
    P2D p1, p2, p3, p0[5];
    CIRC c1, c2, c3, c4;
    int i, j, k, n, i0, i1, i2, i3;
    double rad;
    /*
    l[0].a = 1.2; l[0].b = 1.; l[0].c = -10;
    l[1].a = 1.; l[1].b = 0.2; l[1].c = -3;
    l[2].a = 1.; l[2].b = -2.; l[2].c = -10;
    l[3].a = 0.; l[3].b = 1.; l[3].c = 2;
    l[4].a = .4; l[4].b = 2.; l[4].c = 7;
    */
    l[0].a = 1.2; l[0].b = 1.; l[0].c = -10;
    l[1].a = 1.; l[1].b = 0.2; l[1].c = -3;
    l[2].a = 1.; l[2].b = -2.; l[2].c = -10;
    l[3].a = 0.; l[3].b = 1.; l[3].c = 2;
    l[4].a = .4; l[4].b = 2.; l[4].c = -5.;
    for(i = 0; i < 2; i++) {
        printf("line %f %f %f\n", l[i].a, l[i].b, -l[i].c);
    }
    if(kouten(l[0], l[1], &p1) == 0) exit(0);
    printf("color 0 0 3\n");
    printf("disk %f %f .2\n", p1.x, p1.y);
    printf("pause\n");
    printf("color 0 0 0\n");
    for(i = 0; i < 3; i++) {
        printf("line %f %f %f\n", l[i].a, l[i].b, -l[i].c);
    }
    printf("color 3 0 0\n");
    if(kouten(l[0], l[1], &p1) == 0) exit(0);
    if(kouten(l[2], l[1], &p2) == 0) exit(0);
    if(kouten(l[0], l[2], &p3) == 0) exit(0);
    printf("color 0 0 3\n");
    printf("disk %f %f .2\n", p2.x, p2.y);
    printf("disk %f %f .2\n", p3.x, p3.y);
    gaishin(p1, p2, p3, &c1);
    printf("color 3 0 0\n");
    printf("circle %f %f %f\n", c1.x, c1.y, c1.r);
    printf("pause\n");
    printf("clear\ncolor 0 0 0\n");
    for(i = 0; i < 4; i++) {
        printf("line %f %f %f\n", l[i].a, l[i].b, -l[i].c);
    }
    printf("color 3 0 0\n");
    for(i = 0; i < 2; i++) {
        for(j = i + 1; j < 3; j++) {
	    if(kouten(l[i], l[j], &p1) == 0) exit(0);
	    for(k = j + 1; k < 4; k++) {
	        if(kouten(l[k], l[j], &p2) == 0) exit(0);
	        if(kouten(l[i], l[k], &p3) == 0) exit(0);
		gaishin(p1, p2, p3, &c1);
		printf("circle %f %f %f\n", c1.x, c1.y, c1.r);
	    }
	}
    }
    printf("pause\n");
    printf("color 0 0 0\n");
    for(i = 0; i < 5; i++) {
        printf("line %f %f %f\n", l[i].a, l[i].b, -l[i].c);
    }
    printf("color 3 2 2\n");
    for(i = 0; i < 3; i++) {
        for(j = i + 1; j < 4; j++) {
	    if(kouten(l[i], l[j], &p1) == 0) exit(0);
	    for(k = j + 1; k < 5; k++) {
	        if(kouten(l[k], l[j], &p2) == 0) exit(0);
	        if(kouten(l[i], l[k], &p3) == 0) exit(0);
		gaishin(p1, p2, p3, &c1);
		printf("circle %f %f %f\n", c1.x, c1.y, c1.r);
	    }
	}
    }
    printf("pause\n");
    for(n = 0; n < 5; n++) {
      i0 = 0;
      if(i0 == n) i0++;
      i1 = i0 + 1;
      if(i1 == n) i1++;
      i2 = i1 + 1;
      if(i2 == n) i2++;
      i3 = i2 + 1;
      if(i3 == n) i3++;
    i = i0; j = i1; k = i2;
    printf("copy 0 1\nactive 1\ncolor 2 2 2\nline %f %f %f\n", l[n].a, l[n].b, -l[n].c);
    printf("color 0 0 3\n");
    if(kouten(l[i], l[j], &p3) == 0) exit(0);
    printf("disk %f %f .1\n", p3.x, p3.y);
    if(kouten(l[j], l[k], &p2) == 0) exit(0);
    printf("disk %f %f .1\n", p2.x, p2.y);
    if(kouten(l[k], l[i], &p1) == 0) exit(0);
    printf("disk %f %f .1\n", p1.x, p1.y);
    gaishin(p1, p2, p3, &c1);
    printf("color 3 0 0\ncircle %f %f %f\n", c1.x, c1.y, c1.r);
    i = i0; j = i1; k = i3;
    printf("color 0 0 3\n");
    if(kouten(l[i], l[j], &p3) == 0) exit(0);
    printf("disk %f %f .1\n", p3.x, p3.y);
    if(kouten(l[j], l[k], &p2) == 0) exit(0);
    printf("disk %f %f .1\n", p2.x, p2.y);
    if(kouten(l[k], l[i], &p1) == 0) exit(0);
    printf("disk %f %f .1\n", p1.x, p1.y);
    gaishin(p1, p2, p3, &c2);
    printf("color 3 0 0\ncircle %f %f %f\n", c2.x, c2.y, c2.r);
    i = i0; j = i2; k = i3;
    printf("color 0 0 3\n");
    if(kouten(l[i], l[j], &p3) == 0) exit(0);
    printf("disk %f %f .1\n", p3.x, p3.y);
    if(kouten(l[j], l[k], &p2) == 0) exit(0);
    printf("disk %f %f .1\n", p2.x, p2.y);
    if(kouten(l[k], l[i], &p1) == 0) exit(0);
    printf("disk %f %f .1\n", p1.x, p1.y);
    gaishin(p1, p2, p3, &c3);
    printf("color 3 0 0\ncircle %f %f %f\n", c3.x, c3.y, c3.r);
    i = i1; j = i2; k = i3;
    printf("color 0 0 3\n");
    if(kouten(l[i], l[j], &p3) == 0) exit(0);
    printf("disk %f %f .1\n", p3.x, p3.y);
    if(kouten(l[j], l[k], &p2) == 0) exit(0);
    printf("disk %f %f .1\n", p2.x, p2.y);
    if(kouten(l[k], l[i], &p1) == 0) exit(0);
    printf("disk %f %f .1\n", p1.x, p1.y);
    gaishin(p1, p2, p3, &c4);
    printf("color 3 0 0\ncircle %f %f %f\n", c4.x, c4.y, c4.r);
    m[0].a = 2 * (c2.x - c1.x); m[0].b = 2 * (c2.y - c1.y);
    m[0].c = c1.r * c1.r - c2.r * c2.r - c1.x * c1.x + c2.x * c2.x - c1.y * c1.y + c2.y * c2.y;
    m[1].a = 2 * (c3.x - c1.x); m[1].b = 2 * (c3.y - c1.y);
    m[1].c = c1.r * c1.r - c3.r * c3.r - c1.x * c1.x + c3.x * c3.x - c1.y * c1.y + c3.y * c3.y;
    /*
    printf("color 0 3 0\nline %f %f %f\nline %f %f %f\n", c1.x, c1.y, -c1.r, c2.x, c2.y, -c2.r);
    */
    kouten(m[0], m[1], &p0[n]);
    printf("display 1\npause\n");
    printf("active 0\ndisplay 0\ncolor 0 2 2\ndisk %f %f .2\n", p0[n].x, p0[n].y);
    }
    gaishin(p0[0], p0[1], p0[2], &c1);
    printf("color 0 2 2\ncircle %f %f %f\n", c1.x, c1.y, c1.r);
    return 0;
}
