#include <stdio.h>
#include <stdlib.h>
#include<math.h>

void draw(double x1, double y1, double r, double angle1)
{
    double x2, y2, x3, y3;

    x2 = x1 + r * cos(angle1);
    y2 = y1 + r * sin(angle1);
    x3 = x1 + r * cos(angle1 + M_PI/3.);
    y3 = y1 + r * sin(angle1 + M_PI/3.);
    printf("polygon %f %f %f %f %f %f\n", x1, y1, x2, y2, x3, y3);
    printf("circle %f %f %f %d %d\n", x1, y1, r, (int) (180. * 64 * angle1/M_PI), 60 * 64);
    printf("circle %f %f %f %d %d\n", x2, y2, r, (int) (180. * 64 * angle1/M_PI) + 120 * 64, 60 * 64);
    printf("circle %f %f %f %d %d\n", x3, y3, r, (int) (180. * 64 * angle1/M_PI) + 240 * 64, 60 * 64);
}

main(argc, argv)
    int argc;
    char *argv[];
{
    int i, j, adp = 1;
    double t , dt = .01;

    if(argc > 1) dt = atof(argv[1]);
    printf("active %d\n", adp);
    for(t = M_PI/2.; t > M_PI/6.; t -= dt) {
        printf("color 1 1 1\npolygon -20. -5. 20. -5. 20. -7. -20. -7.\n");
        printf("color 3 0 0\npolygon %f 5. %f 5. %f 5.5 %f 5.5\ncolor 0 0 3\n", -12. + 10. * (M_PI/6. - t), 12. + 10. * (M_PI/6. - t), 12. + 10. * (M_PI/6. - t), -12. + 10. * (M_PI/6. - t));
        draw(-10., -5., 10., t);
        draw(10 * (M_PI/2. - t), 5., 10., M_PI + t);
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	printf("active %d\nclear %d\n", adp, adp);
    }
    for(t = 0.; t < M_PI/3.; t += dt) {
        printf("color 1 1 1\npolygon -20. -5. 20. -5. 20. -7. -20. -7.\n");
        printf("color 3 0 0\npolygon %f 5. %f 5. %f 5.5 %f 5.5\ncolor 0 0 3\n", -12. + 10. * t, 12. + 10. * t, 12. + 10. * t, -12. + 10. * t);
        draw(10 * t - 10., 5., 10., 3. * M_PI/2. - t);
        draw(10. * M_PI/3., -5., 10., M_PI/2. - t);
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
	printf("active %d\nclear %d\n", adp, adp);
    }
    return 0;
  /*    draw(0, 0, 2, M_PI/2. -.1);
   */
}
