typedef struct {
    double r, i;
} CPX;

CPX operator -(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r - x1.r;
    y.i = x2.i - x1.i;
    return y;
}

CPX operator -(CPX x2, double x1)
{
    CPX y;

    y.r = x2.r - x1;
    y.i = x2.i;
    return y;
}

CPX operator +(CPX x2, CPX x1)
{
    CPX y;

    y.r = x2.r + x1.r;
    y.i = x2.i + x1.i;
    return y;
}

CPX operator +(CPX x2, double x1)
{
    CPX y;

    y.r = x2.r + x1;
    y.i = x2.i;
    return y;
}

CPX operator /(CPX x, CPX y)
{
    CPX z;
    double w;

    w = y.r * y.r + y.i * y.i;
    z.r = (x.r * y.r + x.i * y.i) / w;
    z.i = (x.i * y.r - x.r * y.i) / w;
    return z;
}

CPX operator /(CPX x, double y)
{
    CPX z;

    z.r = x.r / y;
    z.i = x.i / y;
    return z;
}

CPX operator /(double x, CPX y)
{
    CPX z;
    double w;

    w = y.r * y.r + y.i * y.i;
    z.r = x * y.r / w;
    z.i = - x * y.i / w;
    return z;
}

CPX operator *(CPX x, CPX y)
{
    CPX z;

    z.r = x.r * y.r - x.i * y.i;
    z.i = x.r * y.i + x.i * y.r;
    return z;
}

CPX operator *(double x, CPX y)
{
    CPX z;

    z.r = x * y.r;
    z.i = x * y.i;
    return z;
}

void operator -=(CPX& x, CPX y)
{
    x.r -= y.r;
    x.i -= y.i;
}
void operator +=(CPX& x, CPX y)
{
    x.r += y.r;
    x.i += y.i;
}

double abs(CPX z)
{
    return sqrt(z.r * z.r + z.i * z.i);
}

CPX atocpx(char *s)
{
    CPX z;
    char *t;
    double sgn = 1.;

    t = s;
    if(*t == '-' ) {
	t++;
	if(*t == 'i') {
	    sgn = -1.;
	    s = t;
	}
    }
    for(; *t != 0; t++) {
	if(*t == '+' || *t == '-' || *t == 'i') break;
    }
    if(*t == 0) {
	z.i = .0;
	sgn = .0;
    }
    else if(*t == '-') sgn = -1.;
    if(*t == 'i' && s == t) z.r = 0.;
    else {
	*t = 0;
	z.r = atof(s);
    }
    if(sgn == .0) return z;
    if(*(++t) == 'i') t++;
    for(s = t; ; t++) if(*t == 0) break;
    if(s == t) z.i = sgn;
    else z.i = sgn * atof(s);
    return z;
}

CPX rtofcpx(CPX z)
{
    CPX w;
    double a, s, a2, s2;

    a = sqrt(z.r * z.r + z.i * z.i);
    s = acos(z.r / a);
    if(z.i < 0.) s *= -1.;
    a2 = sqrt(a); s2 = s / 2.;
    w.r = a2 * cos(s2); w.i = a2 * sin(s2);
    return w;
}
