#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 400
#define MDIM 4

struct cpx {
    double r, i;
} a[MAXN * MDIM * MDIM];

void mcm(struct cpx a[], struct cpx b[], struct cpx c[]);
void display(struct cpx a[]);
int alex(struct cpx a[], int n);
int cutstowd(char *s, char *a[]);
int getline(char *s);
struct cpx atocpx(char *s);

int DIM;

main(int argc, char *argv[])
{
    int i, j, k, l, m = 0, n = 4;
    char s[256], *ps[10], *pa;

    for(DIM = 3, i = 1; i < argc; i++) {
	if(*(pa = argv[i]) == '-' && (*(++pa) == 'd' || *pa == 'D')) {
	    DIM = atoi(++pa);
	    if(DIM < 2 || DIM > MDIM) {
		fprintf(stderr, "%d < 2 OR %d > %d\n", DIM, DIM, MDIM);
		exit(0);
	    }
	    for( ; i < argc - 1; i++) argv[i] = argv[i + 1];
	    break;
	}
    }
    if(argc > 1) n = atoi(argv[1]) + 1;
/*
    a[0].r = 1.; a[0].i = 0.; 
    a[1].r = 0.; a[1].i = 0.; 
    a[2].r = 0.; a[2].i = 0.; 
    a[3].r = 0.; a[3].i = 0.; 
    a[4].r = 1.; a[4].i = 0.; 
    a[5].r = 0.; a[5].i = 0.; 
    a[6].r = 0.; a[6].i = 0.; 
    a[7].r = 0.; a[7].i = 0.; 
    a[8].r = 1.; a[8].i = 0.; 
*/
    for(i = 0; i < DIM * DIM; i++) a[i].r = a[i].i = 0.;
    for(i = 0; i < DIM ; i++) a[i * DIM + i].r = 1.;
    for(i = 1; i < n; i++) {
	for(j = 0; j < DIM * DIM; ) {
	    if(getline(s) == 0) continue;
	    l = cutstowd(s, ps);
	    for(k = 0; k < l; k++) {
		a[i * DIM * DIM + j++] = atocpx(ps[k]);
		if(j == DIM * DIM) break;
	    }
	}
    }

    for(i = 0; i < n; i++) display(a + i * DIM * DIM);
    for( ; ; ) {
	for(i = 0; i <= m; i++) {
	    mcm(a + i * DIM * DIM, a + m * DIM * DIM,  a + n * DIM * DIM);
	    if(alex(a, n) == -1) {
		fprintf(stderr, "%d:\n", n);
		display(a + n * DIM * DIM);
		n++;
		if(n >= MAXN) exit(0);
	    }
	}
	if(++m == n) break;
    }
    for(i = 0; i < n; i++) {
	for(j = 0; j < n; j++) {
	    mcm(a + i * DIM * DIM, a + j * DIM * DIM,  a + n * DIM * DIM);
	    printf("%d ", alex(a, n));
	}
	printf("\n");
    }
    return 0;
}

void display(struct cpx a[])
{
    int i, j;

    for(i = 0; i < DIM; i++) {
	for(j = 0; j < DIM; j++) fprintf(stderr, "%f + i %f   ", a[i * DIM + j].r, a[i * DIM + j].i);
	fprintf(stderr, "\n");
    }
    fprintf(stderr, "\n");
}

void mcm(struct cpx a[], struct cpx b[], struct cpx c[])
{
    int i, j, k, l;

    for(i = 0; i < DIM; i++) {
	for(k = 0; k < DIM; k++) {
	    c[l = i * DIM + k].r = c[l].i = 0.;
	    for(j = 0; j < DIM; j++) {
		c[l].r += (a[i * DIM + j].r * b[j * DIM + k].r - a[i * DIM + j].i * b[j * DIM + k].i);
		c[l].i += (a[i * DIM + j].r * b[j * DIM + k].i + a[i * DIM + j].i * b[j * DIM + k].r);
	    }
	}
    }
}

int alex(struct cpx a[], int n)
{
    int i, j;
    double gosa;

    for(i = 0; i < n; i++) {
	for(j = 0; j < DIM * DIM; j++) {
	    if((gosa = a[i * DIM * DIM + j].r - a[n * DIM * DIM + j].r) >.001 || gosa < -.001) break;
	    if((gosa = a[i * DIM * DIM + j].i - a[n * DIM * DIM + j].i) >.001 || gosa < -.001) break;
	}
	if(j == DIM * DIM) return i;
    }
    return -1;
}
