#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int m = 1, n = 2;
double t0 = 0.;

double xx(double t)
{
    return cos(m * t + t0);
}

double yy(double t)
{
    return sin(n * t);
}

main(int argc, char *argv[])
{
    double t, dt = M_PI / 500., s = 0., x0, y0, x1, y1;

    if(argc > 1) m = atoi(argv[1]);
    if(argc > 2) n = atoi(argv[2]);
    if(argc > 3) t0 = atof(argv[3]);
    x0 = xx(0.); y0 = yy(0.);
    for(t = dt; t < 2 * M_PI; t += dt) {
        x1 = xx(t);
	y1 = yy(t);
        printf("connect %f %f %f %f\n", x0, y0, x1, y1);
	s += sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
	x0 = x1; y0 = y1;
    }
    fprintf(stderr, "Ĺ = %f, m = %d, n = %d, t0 = %f\n", s, m, n, t0);
    return 0;
}
