#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 100

double x[MAXN], y[MAXN];

double df(double fx, double fy, int i, int j)
{
    double xx, yy;

    xx = x[i] - x[j];
    yy = y[i] - y[j];
    return (fx * xx + fy * yy) / sqrt(xx * xx + yy * yy);
}

main(int argc, char *argv[])
{
    int n, i, l0, l1, l2;
    double fx, fy, mx = -10000., d;

    if(argc > 1) n = atoi(argv[1]);
    else n = 3;
    if(n >= MAXN) exit(0);
    printf("color 0 0 3\nline 1 0 0\nline 0 1 0\ncolor 0 0 0\n");
    for(i = 0; i < n; i++) {
        scanf("%lf%lf", x + i, y + i);
	printf("disk %f %f .1\n", x[i], y[i]);
	if(x[i] > mx) {
	    mx = x[i];
	    l0 = i;
	}
	else if(x[i] == mx) {
	    if(y[i] < y[l0]) l0 = i;
	}
    }
/*
    printf("%d ܤ (%f, %f)\n", l0, x[l0], y[l0]);
*/
    printf("color 3 0 0\n");
    for(fx = 0., fy = 1., l1 = l0; ; ) {
        for(mx = -10000., l2 = 0, i = 0; i < n; i++) {
	    if(i == l1) continue;
	    if((d = df(fx, fy, i, l1)) > mx) {
	       mx = d;
	       l2 = i;
	    }
	}
	printf("connect %f %f %f %f\n", x[l2], y[l2], x[l1], y[l1]);
	if(l2 == l0) break;
/*
	printf("%d ܤ (%f, %f)\n", l2, x[l2], y[l2]);
*/
	fx = x[l2] - x[l1];
	fy = y[l2] - y[l1];
	l1 = l2;
    }
    return 0;
}
