#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 20

double x[MAXN], y[MAXN], z[MAXN];

int plane(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double *a, double *b, double *c, double *d)
{
    double a1, a2, a3, b1, b2, b3;

    a1 = x2 - x1; a2 = y2 - y1; a3 = z2 - z1;
    b1 = x3 - x1; b2 = y3 - y1; b3 = z3 - z1;
    *a = a2 * b3 - b2 * a3;
    *b = a3 * b1 - b3 * a1;
    *c = a1 * b2 - b1 * a2;
    if(*a == .0 && *b == .0 && *c == .0) return 0;
    *d = *a * x1 + *b * y1 + *c * z1;
    return 1;
}

main(int argc, char *argv[])
{
    int i, j, k, l, n, f;
    double a, b, c, d, s;

    if(argc > 1) n = atoi(argv[1]);
    else n = 4;
    for(i = 0; i < n; i++) scanf("%lf%lf%lf", x + i, y + i, z + i);
    for(i = 0; i < n - 2; i++) {
        for(j = i + 1; j < n - 1; j++) {
	    for(k = j + 1; k < n; k++) {
	        if(plane(x[i], y[i], z[i], x[j], y[j], z[j], x[k], y[k], z[k], &a, &b, &c, &d) == 0) continue;
		for(f = l = 0; l < n; l++) {
		    if(l == i || l == j || l == k) continue;
		    if((s = a * x[l] + b * y[l] + c * z[l] - d) == 0.) continue;
		    if(f * s < 0) break;
		    if(s > 0) f = 1;
		    else f = -1;
		}
		if(l == n) printf("%fx + %fy + %fz = %f\n", a, b, c, d);
	    }
	}
    }
    return 0;
}
