#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXN 100
#define gosa .000001

struct POINTin3D {
    double x, y, z;
} u[MAXN], v;

struct POINTin2D {
    double x, y;
} p[MAXN], q;

struct POINTin2D sptopl(struct POINTin3D u)
{
    struct POINTin2D p;

    p.x = u.x * exp(-u.z / 6.);
    p.y = u.y * exp(-u.z / 6.);
    return p;
}

struct PLANE {
    double a, b, c, d;
} hp[MAXN];

char edge[MAXN * MAXN], on2p[MAXN];
double gr[MAXN];

int plane(struct POINTin3D u1, struct POINTin3D u2, struct POINTin3D u3, struct PLANE *hp)
{
    double a1, a2, a3, b1, b2, b3;

    a1 = u2.x - u1.x; a2 = u2.y - u1.y; a3 = u2.z - u1.z;
    b1 = u3.x - u1.x; b2 = u3.y - u1.y; b3 = u3.z - u1.z;
    hp->a = a2 * b3 - b2 * a3;
    hp->b = a3 * b1 - b3 * a1;
    hp->c = a1 * b2 - b1 * a2;
    if(hp->a == .0 && hp->b == .0 && hp->c == .0) return 0;
    hp->d = hp->a * u1.x + hp->b * u1.y + hp->c * u1.z;
    return 1;
}

main(int argc, char *argv[])
{
    int i, j, k, l, m = 0, n, f, adp = 1;
    double g, s, cz = 0., mz = 0.;
    struct PLANE hp1, hp2;

    if(argc > 1) n = atoi(argv[1]);
    else n = 4;
    if(n > MAXN || n < 3) exit(0);
    for(i = 0; i < n * n; i++) edge[i] = 0;
    for(i = 0; i < n; i++) {
	scanf("%lf%lf%lf", &u[i].x, &u[i].y, &u[i].z);
	if(u[i].z < mz) mz = u[i].z;
	cz += u[i].z;
    }
    cz /= n; cz -= mz;
    for(i = 0; i < n - 2; i++) {
        for(j = i + 1; j < n - 1; j++) {
	    for(k = j + 1; k < n; k++) {
	        if(plane(u[i], u[j], u[k], &hp1) == 0) continue;
		for(f = l = 0; l < n; l++) {
		    if(l == i || l == j || l == k) continue;
		    if((s = hp1.a * u[l].x + hp1.b * u[l].y + hp1.c * u[l].z - hp1.d) == 0) {
		        if(l < k) {
			    if(plane(u[i], u[j], u[l], &hp2) == 1 || l < j) break;
/*
			    if(plane(u[i], u[k], u[l], &hp2) == 1) break;
			    if(plane(u[k], u[j], u[l], &hp2) == 1) break;
*/
			}
			continue;
		    }
		    if(f * s < 0) break;
		    if(s > 0) f = 1;
		    else f = -1;
		}
		if(l == n) {
/*		    printf("%fx + %fy + %fz = %f   (%d, %d, %d)\n", hp1.a, hp1.b, hp1.c, hp1.d, i, j, k);
*/
		    hp[m] = hp1;
		    m++;
		}
	    }
	}
    }
    for(i = 0; i < m - 1; i++) {
	for(j = i + 1; j < m; j++) {
	    for(l = k = 0; k < n; k++) {
		if(((g = hp[i].a * u[k].x + hp[i].b * u[k].y + hp[i].c * u[k].z - hp[i].d) < gosa && g > -gosa) && ((g = hp[j].a * u[k].x + hp[j].b * u[k].y + hp[j].c * u[k].z - hp[j].d) < gosa && g > -gosa)) {
		    on2p[l] = k;
		    if(l > 0) edge[on2p[l - 1] * n + k] = 1;
		    l++;
		}
	    }
	}
    }
    for(i = 0; i < n; i++) u[i].z -= mz;
    for(i = 0; i < n; i++) {
	q = p[i] = sptopl(u[i]);
	if((gr[i] = 1. - exp(-.3 * u[i].z)) < 0.) gr[i] = 0.;
	printf("gray %f\ndisk %f %f .03\n", gr[i], q.x, q.y);
    }
    for(i = 0; i < n * n; i++) {
	j = i / n; k = i % n;
	if(edge[i] == 1) printf("gray %3.2f\nconnect %3.2f %3.2f %3.2f %3.2f\n", (gr[k] + gr[j]) / 2., p[j].x, p[j].y, p[k].x, p[k].y);
    }
    printf("pause\n");
    for(s = 0.; s < 2 * M_PI; s += .005) {
	printf("active %d\nclear\n", adp);
	for(i  = 0; i < n; i++) {
	    v.x = u[i].x * cos(s) + (u[i].z - cz) * sin(s); v.y = u[i].y;
	    v.z = -u[i].x * sin(s) + (u[i].z - cz) * cos(s) + cz;
	    q = p[i] = sptopl(v);
	    if((gr[i] = 1. - exp(-.3 * v.z)) < 0.) gr[i] = 0.;
	    printf("gray %f\ndisk %f %f .03\n", gr[i], q.x, q.y);
	}
	printf("gray 0.\n");
	for(i = 0; i < n * n; i++) {
	    j = i / n; k = i % n;
	    if(edge[i] == 1) printf("gray %3.2f\nconnect %3.2f %3.2f %3.2f %3.2f\n", (gr[k] + gr[j]) / 2., p[j].x, p[j].y, p[k].x, p[k].y);
	}
	printf("display %d\n", adp);
	if(adp == 1) adp = 2;
	else adp = 1;
    }
    return 0;
}
