#include <stdio.h>
#include <stdlib.h>

#define MAXN 100
#define MAXP 100

typedef struct PT{
    int x, y, z;
} ptin3d;

ptin3d pt[MAXN];

typedef struct PL {
    int a, b, c, d;
} plane;

plane pln[MAXP];
int nofp = 0;

int adjm(int a[], int i, int j)
{
    int c[2], r[2], k, m, f;

    if(((i + j) % 2) == 0) f = 1;
    else f = -1;
    for(k = m = 0; k < 3; k++) {
	if(k == i) continue;
	c[m++] = k;
    }
    for(k = m = 0; k < 3; k++) {
	if(k == j) continue;
	r[m++] = k;
    }
    return f * (a[c[0] * 3 + r[0]] * a[c[1] * 3 + r[1]] - a[c[1] * 3 + r[0]] * a[c[0] * 3 + r[1]]);
}

plane plth3pts(ptin3d p, ptin3d q, ptin3d r)
{
    int j = 0, a[9];
    plane pl;

    a[j++] = p.x; a[j++] = p.y; a[j++] = p.z;
    a[j++] = q.x; a[j++] = q.y; a[j++] = q.z;
    a[j++] = r.x; a[j++] = r.y; a[j++] = r.z;
    pl.a = adjm(a, 0, 0) + adjm(a, 1, 0) + adjm(a, 2, 0);
    pl.b = adjm(a, 0, 1) + adjm(a, 1, 1) + adjm(a, 2, 1);
    pl.c = adjm(a, 0, 2) + adjm(a, 1, 2) + adjm(a, 2, 2);
    pl.d = a[0] * adjm(a, 0, 0) + a[3] * adjm(a, 1, 0) + a[6] * adjm(a, 2, 0);
    return pl;
}

int prod(plane pl, ptin3d p)
{
    return pl.a * p.x + pl.b * p.y + pl.c * p.z - pl.d;
}

main(int argc, char *argv[])
{
    int i, j, k, l, m, f, g, n = 4;
    plane pl;

    if(argc > 1) {
	n = atoi(argv[1]);
	if(n < 3 || n >= MAXN) exit(0);
    }
    for(i = 0; i < n; i++) scanf("%d%d%d", &pt[i].x, &pt[i].y, &pt[i].z);
    for(i = 0; i < n - 2; i++) {
	for(j = i + 1; j < n - 1; j++) {
	    for(k = j + 1; k < n; k++) {
		for(l = 0; l < nofp; l++) {
		    if((prod(pln[l], pt[i]) == 0) && (prod(pln[l], pt[j]) == 0) && (prod(pln[l], pt[k]) == 0)) break;
		}
		if(l < nofp) continue;
		pl = plth3pts(pt[i], pt[j], pt[k]);
		if((pl.a == 0) && (pl.b == 0) && (pl.c == 0)) continue;
		for(l = 0, f = 0; l < n; l ++) {
		    if((l == i) || (l == j) || (l == k)) continue;
		    g = prod(pl, pt[l]);
		    if((g != 0) && (f == 0)) f = g;
		    else if(f * g < 0) break;
		}
		if(l == n) {
		    int gd = gcd(pl.a, pl.b);
		    gd = gcd(gd, pl.c);
		    gd = gcd(gd, pl.d);
		    if(gd > 1) {
			pl.a /= gd; pl.b /= gd; pl.c /= gd; pl.d /= gd;
		    }
		    pln[nofp++] = pl;
		    printf("%dx + %dy + %dz = %d : ", pl.a, pl.b, pl.c, pl.d);
		    for(m = 0; m < n; m++) if(prod(pl, pt[m]) == 0) printf("%d ", m);
		    printf("\n");
		}
	    }
	}
    }
    return 0;
}
