#include <stdio.h>

typedef struct {
    int x, y;
} ptin2D;

int p = 11;

int powermod(int a, int x, int n)
{
    int i, p = 1, ap;

    if(a < 0) a += n;
    ap = a;
    for( ; ; ) {
	if((x % 2) == 1) {
	    p *= ap;
	    p %= n;
	}
	if((x /= 2) == 0) break;
	ap *= ap;
	ap %= n;
    }
    return p;
}

ptin2D kouten(ptin2D P, ptin2D Q)
{
    int a;
    ptin2D R;

    if(P.x == -1) {
	R.x = Q.x;
	R.y = p - 1 - Q.y;
	return R;
    }
    if(Q.x == -1) {
	R.x = P.x;
	R.y = p - 1 - P.y;
	return R;
    }
    if((P.x - Q.x) == 0) {
	if(((P.y - Q.y) != 0) || (((2 * P.y + 1) % p) == 0)) {
	    R.x = -1;
	    return R;
	}
	a = (3 * P.x * P.x - 1) * powermod(2 * P.y + 1, p - 2, p);
    }
    else {
	a = (P.y - Q.y);
	if(a < 0) a += p;
	a *= powermod((P.x - Q.x), p - 2, p);
    }
    a %= p;
    R.x = a * a - P.x - Q.x;
    for( ; ; ) {
	if(R.x < 0) R.x += p;
	else break;
    }
    R.x %= p;
    R.y = a * R.x + P.y - a * P.x;
    for( ; ; ) {
	if(R.y < 0) R.y += p;
	else break;
    }
    R.y %= p;
    return R;
}
	
main(int argc, char *argv[])
{
    ptin2D O, P, Q, R0, R;

    if(argc < 5) exit(0);
    O.x = O.y = 0;
    P.x = atoi(argv[1]); P.y = atoi(argv[2]);
    Q.x = atoi(argv[3]); Q.y = atoi(argv[4]);
    R0 = kouten(P, Q);
    R = kouten(O, R0);
/*
    printf("(%d, %d) + (%d, %d) = (%d, %d)\n", P.x, P.y, Q.x, Q.y, R0.x, R0.y);
    printf("(%d, %d) + (%d, %d) = (%d, %d)\n", O.x, O.y, R0.x, R0.y, R.x, R.y);
*/
    printf("(%d, %d) + (%d, %d) = ", P.x, P.y, Q.x, Q.y);
    if(R.x == -1) printf("infty\n");
    else printf("(%d, %d)\n", R.x, R.y);
    return 0;
}
