#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define BR 2
#define sr 1

main(int argc, char *argv[])
{
    double xx, x, y, z, x0, y0, z0, t, dt = .001, f, df, df0 = 5., d2f, s = 0.;

    if(argc > 1) df0 = atof(argv[1]);
    printf("line 1 0 0\nline 0 1 0\ncolor 0 0 3\nline 1 0 -3.14\nline 0 1 -1.57\nline 0 1 -3.14\ncolor 3 0 0\n");
/*
    printf("circle 0 0 1\ncircle 0 0 3\ncolor 3 0 0\n");
*/
    x0 = BR + sr; y0 = z0 = 0;
    for(f = 0., t = 0., df = df0; t < M_PI; t+= dt) {
	f += df * dt;
	printf("point %f %f\n", t, f);
	xx = BR + sr * cos(f);
	d2f = -(2. * sr * df * df / xx + xx / sr) * sin(f);
	df += d2f * dt;
	x = xx * cos(t);
	y = xx * sin(t);
	z = sr * sin(f);
	s += sqrt((x - x0) * (x - x0) + (y - y0) * (y - y0) + (z - z0) * (z - z0));
	x0 = x; y0 = y; z0 = z;
/*
	printf("point %f %f\n", x, y);
*/
    }
    fprintf(stderr, "distance = %f, v = %f\n", s, f);
    return 0;
}
