#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define BR 2
#define sr 1

main(int argc, char *argv[])
{
    double xx, x, y, z, x0, y0, z0, t, dt = .001, f, df, df0 = 5., d2f, s = 0.;

    if(argc > 1) df0 = atof(argv[1]);
    x0 = BR + sr; y0 = z0 = 0;
    for(t = 0.; t < M_PI; t += .01) printf("gray %f\ncircle 0 0 %f\n", sin(t), BR + sr * cos(t));
    printf("color 3 0 0\n");
    for(f = 0., t = 0., df = df0; t < 2 * M_PI; t+= dt) {
	f += df * dt;
	xx = BR + sr * cos(f);
	d2f = -(2. * sr * df * df / xx + xx / sr) * sin(f);
	df += d2f * dt;
	x = xx * cos(t);
	y = xx * sin(t);
	z = sr * sin(f);
	s += sqrt((x - x0) * (x - x0) + (y - y0) * (y - y0) + (z - z0) * (z - z0));
	if(z > 0) printf("color 3 0 0\n");
	else printf("color 2 1 1\n");
	printf("point %f %f\n", x, y);
	x0 = x; y0 = y; z0 = z;
    }
    printf("color 0 0 0\nText 0 20 distance = %f\n", s);
    return 0;
}
