#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

#define NUMOFBUTTON 1
#define END 0
#define EXEC 1
#define BUTTON_WIDTH 50
#define BUTTON_HEIGHT 26
#define MAX_CANVAS_WIDTH 1000
#define MAX_CANVAS_HEIGHT 750
#define DRAW_BLACK 1
#define DRAW_WHITE 2
#define MNP 100
#define NOFC 64
#define CSTEP 16384
#define SCALE 10.
#define NUMOFCMDS 22
#define NUMOFSCN 3
#define MAXD 15
#define HAK_WIDTH 140
#define HAK_HEIGHT 26
#define MXSTRLH 4096
#define MXNOFWD 250

Display *display;
char *button_name[] = {"End"}, *hak_st = "Hit any key";
Window top;
Window buttons[NUMOFBUTTON], hakw;
GC buttonGC, hakGC;
Font font;
Window canvas;
GC canvasGC;
Pixmap pixmap[NUMOFSCN];
GC pmGC;
GC clearGC;
int commandX, commandY, path;
Colormap cmap;
XColor color[NOFC + 101];
XPoint points[MNP];
char *grcmds[]={"color", "point", "line", "ellipse", "polygon", "curve", "circle", "stop", "sleep", "copy", "connect", "active", "display", "clear", "text", "disk", "Disk", "pause", "Text", "gray", "flush", "end", 0};
char sleep_str[20];
int ox, oy, TOP_WIDTH, TOP_HEIGHT, CANVAS_WIDTH, CANVAS_HEIGHT, adp, ddp;
double scale;

double c[(MAXD + 1) * (MAXD + 2) / 2], x[(MAXD + 1) * MAXD], z[MAXD];
void grdt(int degree, double d[]);
double solvae(int degree, double c[], double x0);
int fdallsol(int degree, double c[], double z[]);
int getpoly(int md, double c[], char *s)
{
    int x, y, d, dd = 0, top = (md + 1) * (md + 2) / 2 - 1;
    char *s0, cs, xoy;
    double f, w = 0;

    for(; *s != 0; ) {
	x = y = 0; f = 1.;
	if(*s == '+') s++;
	if(*s == '-') {
	    f = -1.;
	    s++;
	}
	for(s0 = s; ; s++) if((*s > '9' || *s < '0') && *s != '.') break;
	if((*s != 'x') && (*s != 'y') && (*s != 0) && (*s != '+') && (*s != '-')) return -1;
	if(s0 == s) w = 1.;
	else {
	    cs = *s; *s = 0;
	    w = atof(s0);
	    *s = cs;
	}
	if(((xoy = *s) == 'x') || (xoy == 'y')) {
	    s++;
	    if(*s == '^') s++;
	    for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
	    if(s0 == s) {
		if(xoy == 'x') x = 1;
		else y = 1;
	    }
	    else {
		cs = *s; *s = 0;
		if(xoy == 'x') x = atoi(s0);
		else y = atoi(s0);
		*s = cs;
	    }
	}
	if(((xoy = *s) == 'x') || (xoy == 'y')) {
	    s++;
	    if(*s == '^') s++;
	    for(s0 = s; ; s++) if(*s > '9' || *s < '0') break;
	    if(s0 == s) {
		if(xoy == 'x') x = 1;
		else y = 1;
	    }
	    else {
		cs = *s; *s = 0;
		if(xoy == 'x') x = atoi(s0);
		else y = atoi(s0);
		*s = cs;
	    }
	}
	if((d = x + y) > md) return 0;
	if(d > dd) dd = d;
	c[top - d * (d + 1) / 2 - x] += f * w;
    }
    return dd;
}

main(argc, argv)
    int argc;
    char *argv[];
{
    char *server, *ps;
    int i, dox = 0, doy = 0;
    unsigned short red, green, blue;

    CANVAS_WIDTH = 640, CANVAS_HEIGHT = 480;
    scale = SCALE;
	for(i = 1; i < argc; i++) {
		if(*(ps = argv[i]) != '-') continue;
		ps++;
		if(*ps == 'W' | *ps == 'w') {
			if(*(++ps) == '=') ps++;
			if((CANVAS_WIDTH = atoi(ps)) > MAX_CANVAS_WIDTH) CANVAS_WIDTH = MAX_CANVAS_WIDTH;
			continue;
		}
		if(*ps == 'H' | *ps == 'h') {
			if(*(++ps) == '=') ps++;
			if((CANVAS_HEIGHT = atoi(ps)) > MAX_CANVAS_HEIGHT) CANVAS_HEIGHT = MAX_CANVAS_HEIGHT;
			continue;
		}
/*		if(*ps == 'F' | *ps == 'f') {
			if(*(++ps) == '=') ps++;
			savefilename = ps;
			continue;
		}
*/
		if(*ps == 'X' | *ps == 'x') {
			if(*(++ps) == '=') ps++;
			dox = atoi(ps);
			continue;
		}
		if(*ps == 'Y' | *ps == 'y') {
			if(*(++ps) == '=') ps++;
			doy = atoi(ps);
			continue;
		}
		if(*ps == 'S' | *ps == 's') {
			if(*(++ps) == '=') ps++;
			scale = atof(ps);
			continue;
		}
/*		if(*ps == 'C' | *ps == 'c') {
			codr = 1;
		}
*/
	}
    ox = CANVAS_WIDTH/2 + dox; oy = CANVAS_HEIGHT - CANVAS_HEIGHT/2 - doy;
    TOP_WIDTH = CANVAS_WIDTH + 8; TOP_HEIGHT = CANVAS_HEIGHT + 40;
    server = NULL;
    if((display = XOpenDisplay(server)) == NULL) exit(0);
/*    if(argc==1) 
*/
    path = 0;
/*    else if((path=open(argv[1],O_RDONLY))== -1) exit(0);
*/
    cmap = DefaultColormap(display, DefaultScreen(display));
    for(i = 0, red = green = blue = CSTEP - 1; i < NOFC; i++) {
        color[i].red = red; color[i].green = green; color[i].blue = blue;
	XAllocColor(display, cmap, &color[i]);
	red += CSTEP;
	if(red < CSTEP) {
	    green += CSTEP;
	    if(green < CSTEP) {
	        blue += CSTEP;
	    }
	}
    }
    for(i = 0; i <= 100; i++) {
        color[NOFC + i].red = color[NOFC + i].green = color[NOFC + i].blue = 65535 * i / 100;
	XAllocColor(display, cmap, &color[NOFC + i]);
    }
/*    color[63].red = 201 * 256; color[63].green = 201 * 256; color[63].blue = 201 * 256;
    if(XAllocColor(display, cmap, &color[63]) == False) {
        printf("False\n");
	XCloseDisplay(display);
	exit(0);
    }
*/
    CreateResource();
    EventLoop();
    DestroyResource();
    XCloseDisplay(display);
    if(path>0) close(path);
}

CreateResource()
{
    int x, i;
    Cursor cursor;

    top = XCreateSimpleWindow(display, DefaultRootWindow(display), 0, 0, TOP_WIDTH, TOP_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));
    XStoreName(display, top, "Graphic Drawing");
    x = 2;
    cursor = XCreateFontCursor(display, XC_coffee_mug);
    XDefineCursor(display, top, cursor);
    for(i = 0; i < NUMOFBUTTON; i++, x += 60) 
        buttons[i] = XCreateSimpleWindow(display, top, x, 2, BUTTON_WIDTH, BUTTON_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));
    hakw = XCreateSimpleWindow(display, top, CANVAS_WIDTH - HAK_WIDTH + 3, 2, HAK_WIDTH, HAK_HEIGHT, 2, BlackPixel(display, DefaultScreen(display)), WhitePixel(display, DefaultScreen(display)));
    cursor = XCreateFontCursor(display, XC_hand1);
    for(i = 0; i < NUMOFBUTTON; i++) XDefineCursor(display, buttons[i], cursor);
    canvas = XCreateSimpleWindow(display, top, 2, 34, CANVAS_WIDTH, CANVAS_HEIGHT, 2, 
			      BlackPixel(display, DefaultScreen(display)), 
			      WhitePixel(display, DefaultScreen(display)));

    XSelectInput(display, top, KeyPressMask);
    for(i = 0; i < NUMOFBUTTON; i++) XSelectInput(display, buttons[i], ExposureMask | ButtonPressMask);
    XSelectInput(display, canvas,  ExposureMask | ButtonPressMask);

    buttonGC = XCreateGC(display, top, 0, 0);
    XSetForeground(display, buttonGC, BlackPixel(display, DefaultScreen(display)));
    hakGC = XCreateGC(display, top, 0, 0);
    XSetForeground(display, hakGC, BlackPixel(display, DefaultScreen(display)));
    canvasGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, canvasGC, BlackPixel(display, DefaultScreen(display)));

    font = XLoadFont(display, "12x24");
    XSetFont(display, buttonGC, font);
    XSetFont(display, hakGC, font);
    font = XLoadFont(display, "8x16");
    XSetFont(display, canvasGC, font);

    XMapWindow(display, top);
    XMapSubwindows(display, top);

    for(i = 0; i < NUMOFSCN; i++) pixmap[i] = XCreatePixmap(display, canvas, CANVAS_WIDTH, CANVAS_HEIGHT, 
			   DefaultDepth(display, DefaultScreen(display)));
    clearGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, clearGC, WhitePixel(display, DefaultScreen(display)));
    for(i = 0; i < NUMOFSCN; i++) XFillRectangle(display, pixmap[i], clearGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
    pmGC = XCreateGC(display, canvas, 0, 0);
    XSetForeground(display, pmGC, BlackPixel(display, DefaultScreen(display)));
    XSetBackground(display, pmGC, WhitePixel(display, DefaultScreen(display)));
}

EventLoop()
{
    XEvent event;
    int drawg();

    XNextEvent(display, &event); ReDraw(&event);
    if(drawg() == 0) return;
    XDrawString(display, buttons[0], buttonGC, 1, 23, button_name[0], strlen(button_name[0]));
/*    Xflush(display);
*/    for(;;) {
        XNextEvent(display, &event);
	switch(event.type)
	{
	  case Expose: ReDraw(&event); break;
	  case ButtonPress: if(HitButton(&event) == END) return; break;
	  case KeyPress : if(HitKey(&event) == END) return; break;
	}
    }
}

ReDraw(event)
    XExposeEvent *event;
{
    int i;

    for(i = 0; i < NUMOFBUTTON; i++) {
        if(event->window == buttons[i]) {
	    XDrawString(display, buttons[i], buttonGC, 1, 23, 
			button_name[i], strlen(button_name[i]));
	    return;
	}
    }
    if(event->window == canvas) {
	XCopyArea(display, pixmap[ddp], canvas, pmGC, event->x, event->y, event->width, event->height, event->x, event->y);
    }
}

HitButton(event)
    XButtonEvent *event;
{
    int button;

    if(event->button == Button1) {
        for(button = 0; button < NUMOFBUTTON; button++) {
	    if(event->window == buttons[button]) {
	        if(button == 0) return END;
		return EXEC;
	    }
	}
	if(event->window == canvas) {
	    commandX = event->x;
	    commandY = event->y;
	}
    }
    return EXEC;
}

HitKey(event)
    XKeyEvent *event;
{
    char ch;
    KeySym keysym;

    XLookupString(event, &ch, 1, &keysym, NULL);
    switch(keysym) {
    case XK_F1:
    case XK_e: return END; break;
    case XK_b: SelectColor(DRAW_BLACK); break;
    case XK_w: SelectColor(DRAW_WHITE); break;
    }
    return EXEC;
}

SelectColor(colornb)
    int colornb;
{
    switch(colornb) {
        case DRAW_BLACK: XSetForeground(display, canvasGC, BlackPixel(display, DefaultScreen(display))); break;
        case DRAW_WHITE: XSetForeground(display, canvasGC, WhitePixel(display, DefaultScreen(display))); break;
    }
}

DestroyResource()
{
    int i;

    XUnloadFont(display, font);
    XFreeGC(display, buttonGC);
    XFreeGC(display, hakGC);
    XFreeGC(display, canvasGC);
    XFreeGC(display, pmGC);
    XFreeGC(display, clearGC);
    for(i = 0; i < NUMOFSCN; i++) XFreePixmap(display, pixmap[i]);
    XDestroySubwindows(display, top);
    XDestroyWindow(display, top);
}

int drawg()
{
    int x, y, colornb;
    int x2, y2, pcolor, bcolor;
    double cx, cy, c0;
    extern char *grcmds[];
    int i, a[MXNOFWD], l;
    char s[MXSTRLH];
    XEvent event;

    adp = ddp = 0;
    setcolor(colornb = 0);
    while(getl(s) >= 2) {
        l = cut(s, a);
        for(i = 0; i < NUMOFCMDS; i++) if(cmpword(s, grcmds[i]) == 0) break;
        if(i == 7) break;
	if(i == NUMOFCMDS - 1) return 0;
        switch(i) {
            case 0: if(l > 3) colornb = atoi(s + a[1]) + 4 * (atoi(s + a[2]) + 4 * atoi(s + a[3]));
	            else if(l>1) colornb = atoi(s + a[1]);
                    setcolor(colornb);
                    break;
            case 1: if(l > 2){
	      /*
                        x = ox + (int)(scale * atof(s+a[1]));
                        y = oy - (int)(scale * atof(s+a[2]));
                        if(ddp == adp) XDrawPoint(display, canvas, canvasGC, x, y);
                        XDrawPoint(display, pixmap[adp], canvasGC, x, y);
	      */
                        int count = l/2, j;
                        if(count > MNP) count = MNP;
			for(j = 0; j < count; j++) {
			    points[j].x = ox + (int)(scale * atof(s+a[2 * j + 1]));
			    points[j].y = oy - (int)(scale * atof(s+a[2 * j + 2]));
			}
                        if(ddp == adp) XDrawPoints(display, canvas, canvasGC, points, count, CoordModeOrigin);
                        XDrawPoints(display, pixmap[adp], canvasGC, points, count, CoordModeOrigin);
                    }
                    break;
            case 2: if(l > 3){
		        double lx = - (double) ox / scale,
			ux = (double) (CANVAS_WIDTH - ox) / scale,
			ly = - (double) (CANVAS_HEIGHT - oy) / scale,
			uy = (double) oy / scale, t, t2;
                        cx = atof(s+a[1]);
                        cy = atof(s+a[2]);
                        c0 = atof(s+a[3]);
			if(cx == .0) {
			    if(cy == .0) break;
			    if((t = -c0/cy) < uy && t > ly) {
				x = ox + (int)(scale * lx);
				y = y2 = oy - (int)(scale * t);
				x2 = ox + (int)(scale * ux);
			        if(ddp == adp) XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
			        XDrawLine(display, pixmap[adp], canvasGC, x, y, x2, y2);
				break;
			    }
			}
			if(cy == .0) {
			    if((t = -c0/cx) < ux && t > lx) {
				x = x2 = ox + (int)(scale * t);
				y = oy - (int)(scale * ly);
				y2 = oy - (int)(scale * uy);
                                if(ddp == adp) XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
                                XDrawLine(display, pixmap[adp], canvasGC, x, y, x2, y2);
				break;
			    }
			}
			if((t = -(cx * lx + c0)/cy) < ly) {
			    if(cy/cx >= .0) break;
			    if((t2 = -(cy * ly + c0)/cx) > ux) break;
			    x = ox + (int)(scale * t2); y = oy - (int)(scale * ly);
			}
			else if(t <= uy) {
			    x = ox + (int)(scale * lx); y = oy - (int)(scale * t);
			}
			else {
			    if(cy/cx <= .0) break;
			    if((t2 = -(cy * uy + c0)/cx) > ux) break;
			    x = ox + (int)(scale * t2); y = oy - (int)(scale * uy);
			}
			if((t = -(cx * ux + c0)/cy) < ly) {
			    x2 = ox + (int)(-scale * (cy * ly + c0)/cx); y2 = oy - (int)(scale * ly);
			}
			else if(t <= uy) {
			    x2 = ox + (int)(scale * ux); y2 = oy - (int)(scale * t);
			}
			else {
			    x2 = ox + (int)(-scale * (cy * uy + c0)/cx); y2 = oy - (int)(scale * uy);
			}
                        if(ddp == adp) XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
                        XDrawLine(display, pixmap[adp], canvasGC, x, y, x2, y2);
                    }
                    break;
            case 3: if(l>3) {
		        int ag1 = 0, ag2 = 360;
                        x = ox + scale * atof(s + a[1]); y = oy - scale * atof(s + a[2]);
	                x2 = scale * atof(s + a[3]);
        	        if(l > 4) y2 = scale * atof(s +a[4]);
                	else y2 = x2;
			if(l > 6) {
			    ag1 = atoi(s + a[5]);
			    ag2 = atoi(s + a[6]);
			}
                          if(ddp == adp) XDrawArc(display, canvas, canvasGC, x - x2, y - y2, 2 * x2, 2 * y2, 64 * ag1, 64 * ag2);
                          XDrawArc(display, pixmap[adp], canvasGC, x - x2, y - y2, 2 * x2, 2 * y2, 64 * ag1, 64 * ag2);
                    }
                    break;
            case 4: if(l > 6){
                        int count, j;
                        count = l/2;
                        if(count > MNP) count = MNP;
                        for(j = 0 ;j < count; j++) {
                            points[j].x = ox + scale * atof(s + a[2 * j + 1]); points[j].y = oy - scale * atof(s + a[2 * j + 2]);
			}
			XSetFillRule(display, canvasGC, EvenOddRule);
			if(ddp == adp) XFillPolygon(display, canvas, canvasGC, points, count, Complex, CoordModeOrigin);
			XFillPolygon(display, pixmap[adp], canvasGC, points, count, Complex, CoordModeOrigin);
                    }
                    break;
            case 5: if(l > 1) {
		        int dd, t = (MAXD + 1) * (MAXD + 2) / 2, t0, df;
			for(i = 0; i < t; i++) c[i] = 0;
			if((dd = getpoly(MAXD, c, s + a[1])) > 1){
			    t0 = (dd + 1) * (dd + 2) / 2;
			    df = t - t0;
			    for(i = 0; i < t0; i++) c[i] = c[i + df];
			    grdt(dd, c);
			}
			else if(dd == -1) {
			    XDrawString(display, canvas, canvasGC, 1, 23, "Parameter of curve must be a polynomial", 39);
			}
		    }
	            break;
            case 6: if(l > 3) {
		        int ag1 = 0, ag2 = 64 * 360;
                          x = ox + (int)(scale * atof(s + a[1]));
			  y = oy - (int)(scale * atof(s + a[2]));
                          x2 = (int)(scale * atof(s + a[3]));
			if(l > 5) {
			    ag1 = atoi(s + a[4]);
			    ag2 = atoi(s + a[5]);
			}
                          if(adp == ddp) XDrawArc(display, canvas, canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, ag1, ag2);
                          XDrawArc(display, pixmap[adp], canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, ag1, ag2);
                      }
                      break;
	    case 8: if(l > 1) {
		          x = atoi(s + a[1]);
			  XSync(display, False);
			  /*
			  sleep(x);
			  */
			  for( ; x > 0; x--) {
			      sprintf(sleep_str, "%d seconds", x);
			      XDrawString(display, hakw, hakGC, 1, 23, sleep_str, 10);
			      XFlush(display);
			      sleep(1);
			      XFillRectangle(display, hakw, clearGC, 0, 0, HAK_WIDTH, HAK_HEIGHT);
			  }
	              }
	              break;
	    case 9: if(l > 2) {
		          if((x = atoi(s + a[1])) > NUMOFSCN - 1 || x < 0 || (y = atoi(s + a[2])) > NUMOFSCN - 1 || y < 0) break;
		          if(ddp == y) XCopyArea(display, pixmap[x], canvas, pmGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0);
		          XCopyArea(display, pixmap[x], pixmap[y], pmGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0);
	            }
	            break;
	    case 10: if(l > 4){
                        int count = l/2, j;
                        if(count > MNP) count = MNP;
                        for(j = 0 ;j < count; j++) {
                            points[j].x = ox + (int)(scale * atof(s + a[2 * j + 1])); points[j].y = oy - (int)(scale * atof(s + a[2 * j + 2]));
			}
			/*
                        x = ox + (int)(scale * atof(s + a[1]));
                        y = oy - (int)(scale * atof(s + a[2]));
                        x2 = ox + (int)(scale * atof(s + a[3]));
                        y2 = oy - (int)(scale * atof(s + a[4]));
                        if(adp == ddp) XDrawLine(display, canvas, canvasGC, x, y, x2, y2);
                        XDrawLine(display, pixmap[adp], canvasGC, x, y, x2, y2);
			*/
                        if(adp == ddp) XDrawLines(display, canvas, canvasGC, points, count, CoordModeOrigin);
                        XDrawLines(display, pixmap[adp], canvasGC, points, count, CoordModeOrigin);
		    }
	            break;
	    case 11: if(l > 1) {
		        if((x = atoi(s + a[1])) > NUMOFSCN - 1 || x < 0) break;
			adp = x;
		    }
	            break;
	    case 12: if(l > 1) {
		        if((x = atoi(s + a[1])) > NUMOFSCN - 1 || x < 0) break;
			ddp = x;
			XCopyArea(display, pixmap[ddp], canvas, pmGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0);
		    }
	            break;
	    case 13:
	            if(ddp == adp) XFillRectangle(display, canvas, clearGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
	            XFillRectangle(display, pixmap[adp], clearGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
	            break;
	    case 14: if(l > 3) {
		         for(i = 4; i < l; i++) *(s + a[i] - 1) = ' ';
		         XDrawString(display, canvas, canvasGC, ox + (int)(scale * atof(s + a[1])), oy - (int)(scale * atof(s + a[2])), s + a[3], strlen(s + a[3]));
		         XDrawString(display, pixmap[adp], canvasGC, ox + (int)(scale * atof(s + a[1])), oy - (int)(scale * atof(s + a[2])), s + a[3], strlen(s + a[3]));
	            }
	            break;
	    case 15:
            case 16: if(l > 3) {
                          x = ox + (int)(scale * atof(s + a[1]));
			  y = oy - (int)(scale * atof(s + a[2]));
                          if(i == 15) x2 = (int)(scale * atof(s + a[3]));
			  else x2 = (int)(atof(s + a[3]));
                          if(adp == ddp) XFillArc(display, canvas, canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, 0, 64 * 360);
                          XFillArc(display, pixmap[adp], canvasGC, x - x2, y - x2, 2 * x2, 2 * x2, 0, 64 * 360);
                     }
                     break;
            case 17: for( ; ; ) {
                          XDrawString(display, hakw, hakGC, 1, 23, hak_st, 11);
	                  XNextEvent(display, &event);
			  XFillRectangle(display, hakw, clearGC, 0, 0, HAK_WIDTH, HAK_HEIGHT);
			  /*
                          XDrawString(display, hakw, hakGC, 1, 23, "           ", 11);
			  */
			  if(event.type == KeyPress) break;
                     }
                     break;
	    case 18: if(l > 3) {
		         for(i = 4; i < l; i++) *(s + a[i] - 1) = ' ';
		         XDrawString(display, canvas, canvasGC, atoi(s + a[1]), atoi(s + a[2]), s + a[3], strlen(s + a[3]));
		         XDrawString(display, pixmap[adp], canvasGC, atoi(s + a[1]), atoi(s + a[2]), s + a[3], strlen(s + a[3]));
	            }
	            break;
	    case 19: if(l > 1) {
                    setcolor(NOFC + (int)(100 * atof(s + a[1])));
	            }
	            break;
	    case 20: XSync(display, False);
	            break;
            default: break;
        }
/*	XCopyArea(display, pixmap[ddp], canvas, pmGC, 0, 0, CANVAS_WIDTH, CANVAS_HEIGHT, 0, 0);
*/
	
    }
    return 1;
}

int setcolor(colornb)
    int colornb;
{
    colornb %= (NOFC + 101);
    XSetForeground(display, canvasGC, color[colornb].pixel);
    XSetForeground(display, pmGC, color[colornb].pixel);
}

int cut(s, a)
    char s[];
    int a[];
{
    int i, d = 0;

    a[d++] = 0;
    for(i = 0; ; i++){
        if(s[i] == ' ' || s[i] == ',' || s[i] == '\n'){
            s[i] = '\0';
	    if((i == 0) || (s[i - 1] != '\0')) {
		a[d++] = i + 1;
		if(d == MXNOFWD) break;
	    }
	    else a[d - 1] = i + 1;
        }
        else if(s[i] == '\0') break;
    }
    if(s[i - 1] == '\0') d--;
    return d;
}

int getl(s)
    char *s;
{
    static int f = 0;
    int l = 0;
    if(f == 1) return -1;
    for(; l < MXSTRLH; s++, l++) {
        if(read(path, s, 1) > 0) {
            if(*s == '\n') {
                *s = '\0';
                return l;
            }
        }
        else {
            if(l == 0) return -1;
                f = 1;
                *s = '\0';
                return l;
        }
    }
    return MXSTRLH;
}

int cmpword(s1, s2)
    char *s1, *s2;
{
    for(;;){
        if(*s1 > *s2) return 1;
        else if(*s1 < *s2) return -1;
        if(*(s1++) == '\0') break;
        s2++;
    }
    return 0;
}

void grdt(int dg, double a[])
{
	int ix, iy, i, j, k, n;
	double c[MAXD];

	for(ix = -ox; ix < CANVAS_WIDTH - ox; ix++) {
		for(x[0] = 1., x[1] = (double)ix * 1./scale, i = 2; i <= dg; i++) x[i] = x[i - 1] * x[1];
		for(i = 0; i <= dg; i++) {
			for(c[dg - i] = 0., j = i, k = dg + 1; k > i; j += k--) c[dg - i] += a[j] * x[k - i - 1];
		}
/*		printf("%d: ", ix);
		for(i = 0; i <= dg; i++) printf("%f ", c[i]);
		printf("\n");
*/		n = fdallsol(dg, c, z);
		for(i = 0; i < n; i++) {
/*		    printf("point %d %d\n", ox + ix, oy - (int)(z[i] * scale));
*/		    if(adp == ddp) XDrawPoint(display, canvas, canvasGC, ox + ix, oy - (int)(z[i] * scale));

		    XDrawPoint(display, pixmap[adp], canvasGC, ox + ix, oy - (int)(z[i] * scale));
		}

	}
	for(iy = oy - CANVAS_HEIGHT; iy < oy; iy++) {
		for(x[0] = 1., x[1] = (double)iy * 1./scale, i = 2; i <= dg; i++) x[i] = x[i - 1] * x[1];
		for(i = 0; i <= dg; i++) {
			for(c[dg - i] = 0., j = dg - i, k = dg; k >= i; j += k--) c[dg - i] += a[j] * x[k - i];
		}
/*		printf("%d: ", iy);
		for(i = 0; i <= dg; i++) printf("%f ", c[i]);
		printf("\n");
*/		n = fdallsol(dg, c, z);
		for(i = 0; i < n; i++) {
/*		    printf("point %d %d\n", ox + (int)(z[i] * scale), oy - iy);
*/		    if(adp == ddp) XDrawPoint(display, canvas, canvasGC, ox + (int)(z[i] * scale), oy - iy);

		    XDrawPoint(display, pixmap[adp], canvasGC, ox + (int)(z[i] * scale), oy - iy);
		}

	}
}

#define gosa .0000000000001

int fdallsol(int degree, double c[], double z[])
{
	int i, n;

	for(n = 0; c[degree] == 0.; degree--, n++) z[n] = 0.;
	for(; degree > 0; degree--, n++) {
		if(((z[n] = solvae(degree, c, -1.1)) > 1000000.) && ((z[n] = solvae(degree, c, 1.1)) > 1000000.)) break;
		for(i = 1; i < degree; i++) {
			c[i] += z[n] * c[i - 1];
		}
	}
	return n;
}

double solvae(int degree, double c[], double x0)
{
	int i, m = 0;
	double f, df;

	for(; m < 100; m++) {
		for(i = 1, x[0] = 1.; i <= degree; i++) x[i] = x[i - 1] * x0;
		for(i = 1, f = c[degree]; i <= degree; i++) f += x[i] * c[degree - i];
		if(f < gosa && f > -gosa) return x0;
		for(i = 1, df = c[degree - 1]; i < degree; i++) df += (i + 1) * x[i] * c[degree - i - 1];
		if(df < gosa && df > -gosa) break;
		f /= df;
		if(f < gosa && f > -gosa) return x0;
		x0 -= f;
	}
	return 1000001.;
}
