#include <stdio.h>
#include <stdlib.h>
#include <math.h>

double ido;

double xx(double t)
{
    return cos(ido) * cos(t);
}

double yy(double t)
{
    return cos(ido) * sin(t);
}

double zz(double t)
{
    return sin(ido);
}

main(int argc, char *argv[])
{
    double t, dt = .0001, s = 0., x0, y0, z0, x1, y1, z1;

    if(argc > 1) ido = atof(argv[1]);
    else ido = 0.;
    x0 = xx(t = 0.); y0 = yy(t); z0 = zz(t);
    for(t = dt; t < 2 * M_PI; t += dt) {
        x1 = xx(t); y1 = yy(t); z1 = zz(t);
	s += sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0) + (z1 - z0) * (z1 - z0));
	x0 = x1; y0 = y1; z0 = z1;
    }
    printf("%f\n", s);
    return 0;
}
