#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define R 2.
#define r 1.

double bairitu;

double u(double t)
{
    return bairitu * sin(M_PI * t);
}

double v(double t)
{
  /*
    if(t < .25) return 0.;
    if(t < .75) return 2 * M_PI * (t - .25);
    return M_PI;
  */
    return M_PI * t;
}

double x(double u, double v)
{
    return (R + r * cos(u)) * cos(v);
}

double y(double u, double v)
{
    return (R + r * cos(u)) * sin(v);
}

double z(double u, double v)
{
    return r * sin(u);
}

main(int argc, char *argv[])
{
    double t, dt = .0001, s = 0., x0, y0, z0, x1, y1, z1, u0, v0;

    if(argc > 1) bairitu = atof(argv[1]);
    else bairitu = 4.;
    u0 = u(0); v0 = v(0);
    x0 = x(u0, v0); y0 = y(u0, v0); z0 = z(u0, v0);
    for(t = dt; t < 1.; t += dt) {
	u0 = u(t); v0 = v(t);
        x1 = x(u0, v0); y1 = y(u0, v0); z1 = z(u0, v0);
	s += sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0) + (z1 - z0) * (z1 - z0));
	x0 = x1; y0 = y1; z0 = z1;
    }
    printf("%f\n", s);
    return 0;
}
