#include <stdio.h>
#include <stdlib.h>
#include <math.h>

struct POINT {
    double x, y;
} pt[2000];

double f(double t)
{
    return .25 * cos(t) + .45;
}

double g(double t)
{
    return sin(t) + .4;
}

double df(double t)
{
    return -.25 * sin(t);
}

double dg(double t)
{
    return cos(t);
}

main(int argc, char *argv[])
{
    int i, j;
    double t, x, y, z, s = 0., e = 6.28, dt = .01, x2, y2, x2y2, sx4, sy4;

    if(argc > 1) s = atof(argv[1]);
    if(argc > 2) e = atof(argv[2]);
    if(argc > 3) dt = atof(argv[3]);

/*    printf("s = %f, e = %f, dt = %f\n", s, e, dt);
*/
    for(i = 0, t = s; t <= e; t += dt, i++) {
	x = df(t); y = dg(t);
	z = f(t) * y - g(t) * x;
	printf("color 0 3 0\nellipse .45 -.4 .25 1.\n");
	printf("color 3 0 0\n");
	for(j = 0; j < i; j++) printf("point %f %f\n", pt[j].x, pt[j].y);
	printf("color 0 0 0\ncircle 0 0 1\n");
	printf("color 0 0 3\nline %f %f %f\n", -y, x, z);
	if(z > .001 || z < -.001) {
	    printf("color 3 0 0\npoint %f %f\n", pt[i].x = y / z, pt[i].y = -x / z);
	    x /= z; y /= z; y2 = x * x; x2 = y * y;
	    if(x2 + y2 > 1.) {
		x2y2 = x2 + y2; sy4 = sqrt(x2 * y2 + y2 * y2 - y2); sx4 = sqrt(x2 * y2 + x2 * x2 - x2);
		if(y > 0.) {
		    if(x > 0.) printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y - sy4)/x2y2, (-x - sx4)/x2y2, (y + sy4)/x2y2, (-x + sx4)/x2y2);
		    else printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y - sy4)/x2y2, (-x + sx4)/x2y2, (y + sy4)/x2y2, (-x - sx4)/x2y2);
		}
		else {
		    if(x > 0.) printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y + sy4)/x2y2, (-x - sx4)/x2y2, (y - sy4)/x2y2, (-x + sx4)/x2y2);
		    else printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y + sy4)/x2y2, (-x + sx4)/x2y2, (y - sy4)/x2y2, (-x - sx4)/x2y2);
		}
	    }
	}
	else pt[i].x = pt[i].y = 0.;
	printf("change\n");
    }
    return 0;
}
