#include <stdio.h>
#include <stdlib.h>
#include <math.h>

struct POINT {
    double x, y;
} pt[2000];

int n;

double f(double t)
{
    return cos(n * t) * .5 + .1;
}

double g(double t)
{
    return sin(2 * t) * .5 + .3;
}

double df(double t)
{
    return -n * sin(n * t) * .5;
}

double dg(double t)
{
    return 2 * cos(2 * t) * .5;
}

void draw(void)
{
    double t, f0, g0, f1, g1;

    f0 = f(0); g0 = g(0);
    printf("color 0 3 0\n");
    for(t = .01; t < 6.285; t += .01) {
	printf("connect %f %f %f %f\n", f0, g0, f1 = f(t), g1 = g(t));
	f0 = f1; g0 = g1;
    }
}

main(int argc, char *argv[])
{
    int i, j;
    double t, x, y, z, s = -3.1415, e = 3.15, dt = .01, x2, y2, x2y2, sx4, sy4;

/*
    if(argc > 1) s = atof(argv[1]);
    if(argc > 2) e = atof(argv[2]);
    if(argc > 3) dt = atof(argv[3]);

    printf("s = %f, e = %f, dt = %f\n", s, e, dt);
*/
    if(argc > 1) n = atoi(argv[1]);
    else n = 1;
    for(i = 0, t = s; t <= e; t += dt, i++) {
	x = df(t); y = dg(t);
	z = f(t) * y - g(t) * x;
/*	printf("color 0 3 0\ncurve 4 4. 0 0 0 0 0 0 0 0 -4. 0 1. 0 -3. 2.25\n");
*/
	draw();
	printf("color 3 0 0\n");
	for(j = 1; j < i; j++) { 
	    if(pt[j - 1].x * pt[j].x > .0 || pt[j - 1].y * pt[j].y > .0) printf("connect %f %f %f %f\n", pt[j - 1].x, pt[j - 1].y, pt[j].x, pt[j].y);
	}
	printf("color 0 0 0\ncircle 0 0 1\n");
	printf("color 0 0 3\nline %f %f %f\n", -y, x, z);
	if(z > .001 || z < -.001) {
	    printf("color 3 0 0\npoint %f %f\n", pt[i].x = y / z, pt[i].y = -x / z);
	    if(i > 0 && (pt[i - 1].x * pt[i].x > .0 || pt[i - 1].x * pt[i].x > .0)) printf("connect %f %f %f %f\n", pt[i - 1].x, pt[i - 1].y, pt[i].x, pt[i].y);
	    x /= z; y /= z; y2 = x * x; x2 = y * y;
	    if(x2 + y2 > 1.) {
		x2y2 = x2 + y2; sy4 = sqrt(x2 * y2 + y2 * y2 - y2); sx4 = sqrt(x2 * y2 + x2 * x2 - x2);
		if(y > 0.) {
		    if(x > 0.) printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y - sy4)/x2y2, (-x - sx4)/x2y2, (y + sy4)/x2y2, (-x + sx4)/x2y2);
		    else printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y - sy4)/x2y2, (-x + sx4)/x2y2, (y + sy4)/x2y2, (-x - sx4)/x2y2);
		}
		else {
		    if(x > 0.) printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y + sy4)/x2y2, (-x - sx4)/x2y2, (y - sy4)/x2y2, (-x + sx4)/x2y2);
		    else printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y + sy4)/x2y2, (-x + sx4)/x2y2, (y - sy4)/x2y2, (-x - sx4)/x2y2);
		}
	    }
	}
	else pt[i].x = pt[i].y = 0.;
	printf("change\n");
    }
    return 0;
}
