#include <stdio.h>
#include <stdlib.h>
#include<math.h>

int m, n;

double f(double t)
{
    return cos(m * t);
}

double g(double t)
{
    return sin(n * t);
}

double df(double t)
{
    return -m * sin(m * t);
}

double dg(double t)
{
    return n * cos(n * t);
}

main(int argc, char *argv[])
{
    double t, a, b, c, dt = .001;

    if(argc > 1) m = atoi(argv[1]);
    else m = 1;
    if(argc > 2) n = atoi(argv[2]);
    else n = 2;
    for(t = 0; t < 2 * M_PI; t += dt) {
	a = dg(t); b = -df(t); c = -a * f(t) - b * g(t);
	if(c != 0.) printf("active 0\npoint %f %f\n", a / c, b / c);
	if(b != 0.) printf("active 1\npoint %f %f\n", a / b, c / b);
	if(a != 0.) printf("active 2\npoint %f %f\n", b / a, c / a);
    }
    printf("pause\ndisplay 1\npause\ndisplay 2\n");
    return 0;
}
