#include <stdio.h>
#include <stdlib.h>
#include<math.h>

int n;

double f(double t)
{
    return cos(n * t) * cos(t);
}

double g(double t)
{
    return cos(n * t) * sin(t);
}

double df(double t)
{
    return -n * sin(n * t) * cos(t) - cos(n * t) * sin(t);
}

double dg(double t)
{
    return -n * sin(n * t) * sin(t) + cos(n * t) * cos(t);
}

main(int argc, char *argv[])
{
    double t, a, b, c, dt = .001;

    if(argc > 1) n = atoi(argv[1]);
    else n = 2;
    for(t = 0; t < 2 * M_PI; t += dt) {
	a = dg(t); b = -df(t); c = -a * f(t) - b * g(t);
	if(c != 0.) printf("color 0 0 0\npoint %f %f\n", a / c, b / c);
	if(b != 0.) printf("color 0 0 3\npoint %f %f\n", a / b, c / b);
	if(a != 0.) printf("color 3 0 0\npoint %f %f\n", b / a, c / a);
    }
    return 0;
}
