#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define STEP 200
#define P1 40
#define P2 100
#define P3 130
#define P4 205
#define P5 280
#define P6 350

int n;

typedef struct line {
    double a, b, c;
} LINE;

typedef struct pointin2d {
    double x, y;
} P2D;

LINE ln[7];

P2D pt, pt0, v[7];

double x0 = .25, z0 = .0, r0 = .65;
double tt[] = {P1 * M_PI /STEP, P2 * M_PI /STEP, P3 * M_PI /STEP, P4 * M_PI /STEP, P5 * M_PI /STEP, P6 * M_PI /STEP};

int kouten(LINE l1, LINE l2, P2D *p)
{
    double d;

    if((d = l1.a * l2.b - l1.b * l2.a) == 0.) return 0;
    (*p).x = (l1.c * l2.b - l2.c * l1.b) / d;
    (*p).y = (l1.a * l2.c - l2.a * l1.c) / d;
    return 1;
}

double f(double t)
{
    return r0 * cos(t) + x0;
}

double g(double t)
{
    return r0 * sin(t) + z0;
}

double df(double t)
{
    return -r0 * sin(t);
}

double dg(double t)
{
    return r0 * cos(t);
}

void draw(void)
{
    double t, f0, g0, f1, g1;

    f0 = f(0); g0 = g(0);
    printf("color 0 3 0\n");
    for(t = .01; t < 6.285; t += .01) {
	printf("connect %f %f %f %f\n", f0, g0, f1 = f(t), g1 = g(t));
	f0 = f1; g0 = g1;
    }
}

main(int argc, char *argv[])
{
    int i, j, adp = 1;
    double t, x, y, z, s = 0., e = 2 * M_PI, dt = M_PI /STEP, x2, y2, x2y2, sx4, sy4, ff, gg;

    if(argc > 1) x0 = atof(argv[1]);
    if(argc > 2) z0 = atof(argv[2]);
    if(argc > 3) r0 = atof(argv[3]);
    for(i = 0; i < 6; i++) {
	v[i].x = f(tt[i]);
	v[i].y = g(tt[i]);
    }
    v[6] = v[0];
    draw();
    printf("color 0 2 0\n");
    for(i = 0; i < 6; i++) printf("connect %f %f %f %f\n", v[i].x, v[i].y, v[i+1].x, v[i+1].y);
    printf("color 0 0 0\ndisk 0 0 .03\ncircle 0 0 1\ncopy 0 1\ndisplay %d", adp);

    for(i = 0, t = s; t <= e; t += dt, i++) {
	x = df(t); y = dg(t);
	ff = f(t); gg = g(t);
	z = ff * y - gg * x;
	if(z > .001 || z < -.001) {
	    pt.x = y / z; pt.y = -x / z;
	    printf("color 3 0 0\npoint %f %f\n", pt.x, pt.y);
	    if(i == P1) printf("color 2 0 0\nline %f %f -1.\n", ln[0].a = ff, ln[0].b = gg);
	    else if(i == P2) printf("color 2 0 0\nline %f %f -1.\n", ln[1].a = ff, ln[1].b = gg);
	    else if(i == P3) printf("color 2 0 0\nline %f %f -1.\n", ln[2].a = ff, ln[2].b = gg);
	    else if(i == P4) printf("color 2 0 0\nline %f %f -1.\n", ln[3].a = ff, ln[3].b = gg);
	    else if(i == P5) printf("color 2 0 0\nline %f %f -1.\n", ln[4].a = ff, ln[4].b = gg);
	    else if(i == P6) printf("color 2 0 0\nline %f %f -1.\n", ln[5].a = ff, ln[5].b = gg);
	    if(i > 0 && (pt0.x * pt.x > .0 || pt0.x * pt.x > .0)) printf("connect %f %f %f %f\n", pt0.x, pt0.y, pt.x, pt.y);
	    if(adp == 1) adp = 2;
	    else adp = 1;
	    printf("copy 0 %d\nactive %d\n", adp, adp);
	    printf("color 0 0 3\nline %f %f %f\n", -y, x, z);
	    x /= z; y /= z; y2 = x * x; x2 = y * y;
	    if(x2 + y2 > 1.) {
		x2y2 = x2 + y2; sy4 = sqrt(x2 * y2 + y2 * y2 - y2); sx4 = sqrt(x2 * y2 + x2 * x2 - x2);
		if(y > 0.) {
		    if(x > 0.) printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y - sy4)/x2y2, (-x - sx4)/x2y2, (y + sy4)/x2y2, (-x + sx4)/x2y2);
		    else printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y - sy4)/x2y2, (-x + sx4)/x2y2, (y + sy4)/x2y2, (-x - sx4)/x2y2);
		}
		else {
		    if(x > 0.) printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y + sy4)/x2y2, (-x - sx4)/x2y2, (y - sy4)/x2y2, (-x + sx4)/x2y2);
		    else printf("color 1 2 3\nline %f %f -1.\nline %f %f -1.\n", (y + sy4)/x2y2, (-x + sx4)/x2y2, (y - sy4)/x2y2, (-x - sx4)/x2y2);
		}
	    }
	    pt0.x = pt.x; pt0.y = pt.y;
	}
	else pt0.x = pt0.y = 0.;
	printf("display %d\nactive 0\n", adp);
    }
    printf("pause\ndisplay 0\n");
    for(i = 0; i < 6; i++) ln[i].c = 1.;
    ln[6] = ln[0];
    for(i = 0; i < 6; i++) kouten(ln[i], ln[i + 1], v + i);
    printf("color 0 0 3\n");
    for(i = 0; i < 3; i++) printf("connect %f %f %f %f\n", v[i].x, v[i].y, v[i +3].x, v[i + 3].y);
    return 0;
}
