#include <stdio.h>

#define MAXN 100

typedef struct {
    int x, y;
} ptin2D;

int p;

ptin2D pt[MAXN];

int multimod(int x, int y)
{
    int z = 0, x2 = x;

    for( ; ; ) {
	if((y % 2) == 1) {
	    z += x2;
	    z %= p;
	}
	if((y /= 2) == 0) return z;
	x2 *= 2;
	x2 %= p;
    }
}

int powermod(int a, int x)
{
    int i, pow = 1, ap;

    if(a < 0) a += p;
    ap = a;
    for( ; ; ) {
	if((x % 2) == 1) {
	    pow = multimod(pow, ap);
	}
	if((x /= 2) == 0) return pow;
	ap = multimod(ap, ap);
    }
}

ptin2D kouten(ptin2D P, ptin2D Q)
{
    int a;
    ptin2D R;

    if(P.x == -1) {
	if(Q.x == -1) {
	    R.x = -1;
	    return R;
	}
	R.x = Q.x;
	R.y = p - 1 - Q.y;
	return R;
    }
    if(Q.x == -1) {
	R.x = P.x;
	R.y = p - 1 - P.y;
	return R;
    }
    if(P.x == Q.x) {
	if((P.y != Q.y) || (((2 * P.y + 1) % p) == 0)) {
	    R.x = -1;
	    return R;
	}
	if(P.x == 0) a = p - 1;
	else {
	    a = (3 * multimod(P.x, P.x) - 1);
	    a %= p;
	}
	a = multimod(a, powermod(2 * P.y + 1, p - 2));
    }
    else {
	a = (P.y - Q.y);
	if(a < 0) a += p;
	a = multimod(a, powermod((P.x - Q.x), p - 2));
    }
    a %= p;
    R.x = multimod(a, a) - P.x - Q.x;
    for( ; ; ) {
	if(R.x < 0) R.x += p;
	else break;
    }
    R.x %= p;
    R.y = multimod(a, R.x) + P.y - multimod(a, P.x);
    for( ; ; ) {
	if(R.y < 0) R.y += p;
	else break;
    }
    R.y %= p;
    return R;
}

main(int argc, char *argv[])
{
    int i, j, k, x, y, z, w, n = 0;
    ptin2D O, R0, R;

    if(argc > 1) p = atoi(argv[1]);
    else p = 5;
    if(p < 2 || p >= MAXN) exit(0);
    for(i = 2; i < p; i++) if((p % i) == 0) break;
    if(i < p) {
        fprintf(stderr, "%d ǿǤϤޤ\n", p);
	exit(0);
    }
    O.x = O.y = 0;
    for(x = 0; x < p; x++) {
        w = x * (x * x - 1);
	w %= p;
	for(y = 0; y < p; y++) {
	    z = y * (y + 1);
	    z %= p;
	    if(w == z) {
	        pt[n].x = x;
		pt[n].y = y;
		n++;
	    }
	}
    }
    for(i = 0; i < n; i++) fprintf(stderr, "%d : (%d, %d)\n", i, pt[i].x, pt[i].y);
    fprintf(stderr, "%d : infinity\n", i);
    pt[n].x = -1;
    n++;
    for(i = 0; i < n; i++) {
        for(j = 0; j < n; j++) {
	    R0 = kouten(pt[i], pt[j]);
	    R = kouten(O, R0);
	    for(k = 0; k < n; k++) {
	       if(((R.x == -1) && (pt[k].x == -1)) || ((R.x == pt[k].x) && (R.y == pt[k].y))) break;
	    }
//	    printf("%c ", (char)('A'+k));
	    printf("%d ", k);
	    /*
	    if(k == 0) printf("O ");
	    else if(k < 15) printf("%c ", (char)('A' + k - 1));
	    else printf("%c ", (char)('A' + k));
	    */
	}
	printf("\n");
    }
    return 0;
}
